BEGIN TRANSACTION; 

MERGE dbo.server_configuration AS [Target]
USING (SELECT 'management_server_host_name' AS prop_name, '${MANAGEMENT_SERVER_HOST_NAME}' AS prop_value) AS [Source] 
ON [Target].prop_name = [Source].prop_name
WHEN MATCHED THEN  UPDATE SET [Target].prop_value = [Source].prop_value
WHEN NOT MATCHED THEN  INSERT (prop_name, prop_value) VALUES ([Source].prop_name, [Source].prop_value);

MERGE dbo.server_configuration AS [Target]
USING (SELECT 'management_server_port' AS prop_name, '${MANAGEMENT_SERVER_PORT}' AS prop_value) AS [Source] 
ON [Target].prop_name = [Source].prop_name
WHEN MATCHED THEN  UPDATE SET [Target].prop_value = [Source].prop_value, [Target].created_date = getdate(), [Target].updated_date = getdate()
WHEN NOT MATCHED THEN  INSERT (prop_name, prop_value, created_date, updated_date) VALUES ([Source].prop_name, [Source].prop_value, getdate(), getdate());

MERGE dbo.server_configuration AS [Target]
USING (SELECT 'management_server_user' AS prop_name, '${MANAGEMENT_SERVER_USER}' AS prop_value) AS [Source] 
ON [Target].prop_name = [Source].prop_name
WHEN MATCHED THEN  UPDATE SET [Target].prop_value = [Source].prop_value, [Target].created_date = getdate(), [Target].updated_date = getdate()
WHEN NOT MATCHED THEN  INSERT (prop_name, prop_value, created_date, updated_date) VALUES ([Source].prop_name, [Source].prop_value, getdate(), getdate());

MERGE dbo.server_configuration AS [Target]
USING (SELECT 'management_server_password' AS prop_name, '${MANAGEMENT_SERVER_PASSWORD}' AS prop_value) AS [Source] 
ON [Target].prop_name = [Source].prop_name
WHEN MATCHED THEN  UPDATE SET [Target].prop_value = [Source].prop_value, [Target].created_date = getdate(), [Target].updated_date = getdate()
WHEN NOT MATCHED THEN  INSERT (prop_name, prop_value, created_date, updated_date) VALUES ([Source].prop_name, [Source].prop_value, getdate(), getdate());

MERGE dbo.server_configuration AS [Target]
USING (SELECT 'management_server_scheme' AS prop_name, '${MANAGEMENT_SERVER_SCHEME}' AS prop_value) AS [Source] 
ON [Target].prop_name = [Source].prop_name
WHEN MATCHED THEN  UPDATE SET [Target].prop_value = [Source].prop_value, [Target].created_date = getdate(), [Target].updated_date = getdate()
WHEN NOT MATCHED THEN  INSERT (prop_name, prop_value, created_date, updated_date) VALUES ([Source].prop_name, [Source].prop_value, getdate(), getdate());

MERGE dbo.server_configuration AS [Target]
USING (SELECT 'management_server_truststore_filename' AS prop_name, '${MANAGEMENT_SERVER_TRUSTSTORE_FILENAME}' AS prop_value) AS [Source] 
ON [Target].prop_name = [Source].prop_name
WHEN MATCHED THEN  UPDATE SET [Target].prop_value = [Source].prop_value, [Target].created_date = getdate(), [Target].updated_date = getdate()
WHEN NOT MATCHED THEN  INSERT (prop_name, prop_value, created_date, updated_date) VALUES ([Source].prop_name, [Source].prop_value, getdate(), getdate());

MERGE dbo.server_configuration AS [Target]
USING (SELECT 'management_server_keystore_filename' AS prop_name, '${MANAGEMENT_SERVER_KEYSTORE_FILENAME}' AS prop_value) AS [Source] 
ON [Target].prop_name = [Source].prop_name
WHEN MATCHED THEN  UPDATE SET [Target].prop_value = [Source].prop_value, [Target].created_date = getdate(), [Target].updated_date = getdate()
WHEN NOT MATCHED THEN  INSERT (prop_name, prop_value, created_date, updated_date) VALUES ([Source].prop_name, [Source].prop_value, getdate(), getdate());

MERGE dbo.server_configuration AS [Target]
USING (SELECT 'management_server_truststore_password' AS prop_name, '${MANAGEMENT_SERVER_TRUSTSTORE_PASSWORD}' AS prop_value) AS [Source] 
ON [Target].prop_name = [Source].prop_name
WHEN MATCHED THEN  UPDATE SET [Target].prop_value = [Source].prop_value, [Target].created_date = getdate(), [Target].updated_date = getdate()
WHEN NOT MATCHED THEN  INSERT (prop_name, prop_value, created_date, updated_date) VALUES ([Source].prop_name, [Source].prop_value, getdate(), getdate());

MERGE dbo.server_configuration AS [Target]
USING (SELECT 'management_server_keystore_password' AS prop_name, '${MANAGEMENT_SERVER_KEYSTORE_PASSWORD}' AS prop_value) AS [Source] 
ON [Target].prop_name = [Source].prop_name
WHEN MATCHED THEN  UPDATE SET [Target].prop_value = [Source].prop_value, [Target].created_date = getdate(), [Target].updated_date = getdate()
WHEN NOT MATCHED THEN  INSERT (prop_name, prop_value, created_date, updated_date) VALUES ([Source].prop_name, [Source].prop_value, getdate(), getdate());

MERGE dbo.server_configuration AS [Target]
USING (SELECT 'kony_server_shared_lib_name' AS prop_name, '${KONY_SERVER_SHARED_LIB_NAME}' AS prop_value) AS [Source] 
ON [Target].prop_name = [Source].prop_name
WHEN MATCHED THEN  UPDATE SET [Target].prop_value = [Source].prop_value, [Target].created_date = getdate(), [Target].updated_date = getdate()
WHEN NOT MATCHED THEN  INSERT (prop_name, prop_value, created_date, updated_date) VALUES ([Source].prop_name, [Source].prop_value, getdate(), getdate());

MERGE dbo.server_configuration AS [Target]
USING (SELECT 'server_console_redirect_ip' AS prop_name, '${SERVER_CONSOLE_REDIRECT_IP}' AS prop_value) AS [Source] 
ON [Target].prop_name = [Source].prop_name
WHEN MATCHED THEN  UPDATE SET [Target].prop_value = [Source].prop_value, [Target].created_date = getdate(), [Target].updated_date = getdate()
WHEN NOT MATCHED THEN  INSERT (prop_name, prop_value, created_date, updated_date) VALUES ([Source].prop_name, [Source].prop_value, getdate(), getdate());

MERGE dbo.server_configuration AS [Target]
USING (SELECT 'server_console_redirect_port' AS prop_name, '${SERVER_CONSOLE_REDIRECT_PORT}' AS prop_value) AS [Source] 
ON [Target].prop_name = [Source].prop_name
WHEN MATCHED THEN  UPDATE SET [Target].prop_value = [Source].prop_value, [Target].created_date = getdate(), [Target].updated_date = getdate()
WHEN NOT MATCHED THEN  INSERT (prop_name, prop_value, created_date, updated_date) VALUES ([Source].prop_name, [Source].prop_value, getdate(), getdate());


MERGE dbo.server_configuration AS [Target]
USING (SELECT 'management_server_groups' AS prop_name, '${MANAGEMENT_SERVER_GROUPS}' AS prop_value) AS [Source] 
ON [Target].prop_name = [Source].prop_name
WHEN MATCHED THEN  UPDATE SET [Target].prop_value = [Source].prop_value, [Target].created_date = getdate(), [Target].updated_date = getdate()
WHEN NOT MATCHED THEN  INSERT (prop_name, prop_value, created_date, updated_date) VALUES ([Source].prop_name, [Source].prop_value, getdate(), getdate());

COMMIT TRANSACTION;