CREATE TABLE DEVICEMASTER (
  DEVICEID	BIGINT	NOT NULL,
  USERAGENT	VARCHAR(255)	NOT NULL,
  RCIDENTIFIER	VARCHAR(255),
  PRIMARYSRC	BIGINT	NOT NULL,
  SECONDARYSRC	BIGINT,
  VERSION	BIGINT	NOT NULL with DEFAULT 1,
  CREATETS	TIMESTAMP	NOT NULL	DEFAULT ,
  UPDATETS	TIMESTAMP	NOT NULL	DEFAULT 
) 
  IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};

ALTER TABLE DEVICEMASTER
  ADD CONSTRAINT PRIMARY_7 PRIMARY KEY
    (DEVICEID);

ALTER TABLE DEVICEMASTER
  ADD CONSTRAINT USERAGENTSTABLE UNIQUE
    (USERAGENT);



CREATE TABLE INFO (
  DEVICEID	BIGINT	NOT NULL,
  CAPABILITYNAME	VARCHAR(25)	NOT NULL,
  CAPABILITYVALUE	VARCHAR(255),
  VERSION	BIGINT	NOT NULL with DEFAULT 1,
  UPDATETS	TIMESTAMP	NOT NULL	DEFAULT SYSIBM.TIMESTAMP(CURRENT TIMESTAMP),
  SRC	BIGINT	NOT NULL
) 
  IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};

ALTER TABLE INFO
  ADD CONSTRAINT INFOSTABLE UNIQUE
    (DEVICEID, CAPABILITYNAME);

ALTER TABLE INFO
  ADD CONSTRAINT INFO_IBFK_1 FOREIGN KEY
    (DEVICEID)
  REFERENCES DEVICEMASTER
    (DEVICEID)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
    ENFORCED
    ENABLE QUERY OPTIMIZATION;



CREATE TABLE MARKUP (
  DEVICEID	BIGINT	NOT NULL,
  CAPABILITYNAME	VARCHAR(25)	NOT NULL,
  CAPABILITYVALUE	VARCHAR(255),
  VERSION	BIGINT	NOT NULL with DEFAULT 1,
  UPDATETS	TIMESTAMP	NOT NULL	DEFAULT SYSIBM.TIMESTAMP(CURRENT TIMESTAMP),
  SRC	BIGINT	NOT NULL
) 
  IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};

ALTER TABLE MARKUP
  ADD CONSTRAINT MARKUPSTABLE UNIQUE
    (DEVICEID, CAPABILITYNAME);

ALTER TABLE MARKUP
  ADD CONSTRAINT MARKUP_IBFK_1 FOREIGN KEY
    (DEVICEID)
  REFERENCES DEVICEMASTER
    (DEVICEID)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
    ENFORCED
    ENABLE QUERY OPTIMIZATION;



CREATE TABLE BLACKBERRY (
  DEVICEID	BIGINT	NOT NULL,
  CAPABILITYNAME	VARCHAR(25)	NOT NULL,
  CAPABILITYVALUE	VARCHAR(255),
  VERSION	BIGINT	NOT NULL with DEFAULT 1,
  UPDATETS	TIMESTAMP	NOT NULL	DEFAULT SYSIBM.TIMESTAMP(CURRENT TIMESTAMP),
  SRC	BIGINT	NOT NULL
) 
  IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};

ALTER TABLE BLACKBERRY
  ADD CONSTRAINT BLACKBERRYSTABLE UNIQUE
    (DEVICEID, CAPABILITYNAME);

ALTER TABLE BLACKBERRY
  ADD CONSTRAINT BLACKBERRY_IBFK_1 FOREIGN KEY
    (DEVICEID)
  REFERENCES DEVICEMASTER
    (DEVICEID)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
    ENFORCED
    ENABLE QUERY OPTIMIZATION;



CREATE TABLE BREW (
  DEVICEID	BIGINT	NOT NULL,
  CAPABILITYNAME	VARCHAR(25)	NOT NULL,
  CAPABILITYVALUE	VARCHAR(255),
  VERSION	BIGINT	NOT NULL with DEFAULT 1,
  UPDATETS	TIMESTAMP	NOT NULL	DEFAULT SYSIBM.TIMESTAMP(CURRENT TIMESTAMP),
  SRC	BIGINT	NOT NULL
) 
  IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};

ALTER TABLE BREW
  ADD CONSTRAINT BREWSTABLE UNIQUE
    (DEVICEID, CAPABILITYNAME);

ALTER TABLE BREW
  ADD CONSTRAINT BREW_IBFK_1 FOREIGN KEY
    (DEVICEID)
  REFERENCES DEVICEMASTER
    (DEVICEID)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
    ENFORCED
    ENABLE QUERY OPTIMIZATION;





CREATE TABLE IPHONE (
  DEVICEID	BIGINT	NOT NULL,
  CAPABILITYNAME	VARCHAR(25)	NOT NULL,
  CAPABILITYVALUE	VARCHAR(255),
  VERSION	BIGINT	NOT NULL with DEFAULT 1,
  UPDATETS	TIMESTAMP	NOT NULL	DEFAULT SYSIBM.TIMESTAMP(CURRENT TIMESTAMP),
  SRC	BIGINT	NOT NULL
) 
  IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};

ALTER TABLE IPHONE
  ADD CONSTRAINT IPHONESTABLE UNIQUE
    (DEVICEID, CAPABILITYNAME);

ALTER TABLE IPHONE
  ADD CONSTRAINT IPHONE_IBFK_1 FOREIGN KEY
    (DEVICEID)
  REFERENCES DEVICEMASTER
    (DEVICEID)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
    ENFORCED
    ENABLE QUERY OPTIMIZATION;



CREATE TABLE J2ME (
  DEVICEID	BIGINT	NOT NULL,
  CAPABILITYNAME	VARCHAR(25)	NOT NULL,
  CAPABILITYVALUE	VARCHAR(255),
  VERSION	BIGINT	NOT NULL with DEFAULT 1,
  UPDATETS	TIMESTAMP	NOT NULL	DEFAULT SYSIBM.TIMESTAMP(CURRENT TIMESTAMP),
  SRC	BIGINT	NOT NULL
) 
  IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};

ALTER TABLE J2ME
  ADD CONSTRAINT J2MESTABLE UNIQUE
    (DEVICEID, CAPABILITYNAME);

ALTER TABLE J2ME
  ADD CONSTRAINT J2ME_IBFK_1 FOREIGN KEY
    (DEVICEID)
  REFERENCES DEVICEMASTER
    (DEVICEID)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
    ENFORCED
    ENABLE QUERY OPTIMIZATION;



CREATE TABLE WINDOWS (
  DEVICEID	BIGINT	NOT NULL,
  CAPABILITYNAME	VARCHAR(25)	NOT NULL,
  CAPABILITYVALUE	VARCHAR(255),
  VERSION	BIGINT	NOT NULL with DEFAULT 1,
  UPDATETS	TIMESTAMP	NOT NULL	DEFAULT SYSIBM.TIMESTAMP(CURRENT TIMESTAMP),
  SRC	BIGINT	NOT NULL
) 
  IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};

ALTER TABLE WINDOWS
  ADD CONSTRAINT WINDOWSSTABLE UNIQUE
    (DEVICEID, CAPABILITYNAME);

ALTER TABLE WINDOWS
  ADD CONSTRAINT WINDOWS_IBFK_1 FOREIGN KEY
    (DEVICEID)
  REFERENCES DEVICEMASTER
    (DEVICEID)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION
    ENFORCED
    ENABLE QUERY OPTIMIZATION;

-- 

CREATE TABLE EXPORTHISTORY (
  ID	BIGINT	NOT NULL,
  EXPFILENAME	VARCHAR(50)	NOT NULL,
  CREATETS	TIMESTAMP	NOT NULL
) 
  IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};


CREATE TABLE CLIENTUPDATEHISTORY (
  ID	BIGINT	NOT NULL,
  CLIENTID	VARCHAR(50),
  EXPID	BIGINT
) 
  IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};


CREATE TABLE DATASRCMASTER (
  DATASRCTYPE	VARCHAR(25)	NOT NULL,
  DATASRCID	BIGINT	NOT NULL
) 
  IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};


CREATE TABLE METADATA (
  ID	BIGINT	NOT NULL,
  CAPABILITYGROUP	VARCHAR(50)	NOT NULL,
  CAPABILITYNAME	VARCHAR(50)	NOT NULL
) 
  IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};


CREATE TABLE NEWDEVICES (
  ID	BIGINT	NOT NULL,
  USERAGENT	VARCHAR(200)	NOT NULL,
  CREATETS	TIMESTAMP	NOT NULL	DEFAULT SYSIBM.TIMESTAMP(CURRENT TIMESTAMP)
) 
  IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};

ALTER TABLE NEWDEVICES
  ADD CONSTRAINT PRIMARY_4 PRIMARY KEY
    (ID);



CREATE TABLE POPULARDEVICES (
  ID	BIGINT	NOT NULL,
  USERAGENT	VARCHAR(255)	NOT NULL
) 
  IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};

ALTER TABLE POPULARDEVICES
  ADD CONSTRAINT PRIMARY_5 PRIMARY KEY
    (ID);



CREATE TABLE UPDATEHISTORY (
  ID	BIGINT	NOT NULL,
  SRC	BIGINT	NOT NULL,
  FILENAME	VARCHAR(100),
  UPDATETS	TIMESTAMP	NOT NULL
) 
  IN ${KONY_SERVER_DATA_TABLESPACE} INDEX IN ${KONY_SERVER_INDEX_TABLESPACE};




create view GET_DEVICE_INFO(     DEVICEID,     MANUFACTURER,     MODEL,     PLATFORM  ) as    
  SELECT distinct t1.deviceid, nvl(t2.capabilityvalue,''),nvl(t3.capabilityvalue,''),nvl(t4.capabilityvalue,'')  
  FROM info t1,info t2,info t3,info t4  
  where t1.deviceid=t2.deviceid and t1.deviceid=t3.deviceid and t1.deviceid=t4.deviceid  and t2.capabilityname='manufacturer' and t3.CAPABILITYNAME='model' and t4.CAPABILITYNAME='platform';


ALTER TABLE EXPORTHISTORY ALTER COLUMN ID SET GENERATED AS IDENTITY ( START WITH 0 INCREMENT BY 1 NO CACHE ) ADD CONSTRAINT PK_EXPORTHISTORY PRIMARY KEY ( ID) ;

ALTER TABLE CLIENTUPDATEHISTORY ALTER COLUMN ID SET GENERATED AS IDENTITY ( START WITH 0 INCREMENT BY 1 NO CACHE ) ADD CONSTRAINT PK_CLIENTUPDATEHISTORY PRIMARY KEY ( ID) ADD CONSTRAINT CLIENTUPDATEHISTORY_IBFK_1 FOREIGN KEY (EXPID) REFERENCES EXPORTHISTORY (ID)  ON DELETE CASCADE ON UPDATE NO ACTION ENFORCED  ENABLE QUERY OPTIMIZATION ;

ALTER TABLE METADATA ALTER COLUMN ID SET GENERATED AS IDENTITY ( START WITH 0 INCREMENT BY 1 NO CACHE ) ADD CONSTRAINT PK_METADATA PRIMARY KEY ( ID) ;


ALTER TABLE NEWDEVICES ALTER COLUMN ID SET GENERATED AS IDENTITY ( START WITH 0 INCREMENT BY 1 NO CACHE ) ;

ALTER TABLE POPULARDEVICES ALTER COLUMN ID SET GENERATED AS IDENTITY ( START WITH 0 INCREMENT BY 1 NO CACHE ) ;


-- version view for device data
create view version(tablename,mindeviceid,maxdeviceid,version) as select 'devicemaster',min(deviceid),max(deviceid),version from devicemaster group by version union select 'info',min(deviceid),max(deviceid),version from info group by version union select 'markup',min(deviceid),max(deviceid),version from markup group by version;