--
-- Create table `devicemaster`
--
CREATE TABLE `devicemaster` (
  `deviceid` int(11) NOT NULL auto_increment,
  `useragent` varchar(255) NOT NULL,
  `rcidentifier` varchar(255) default NULL,
  `primarysrc` int(11) NOT NULL,
  `secondarysrc` int(11) default NULL,
  `version` int(11) NOT NULL default '1',
  `createts` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `updatets` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`deviceid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Create table `info`
--
CREATE TABLE `info` (
  `deviceid` int(11) default NULL,
  `capabilityname` varchar(25) NOT NULL,
  `capabilityvalue` varchar(255) default NULL,
  `version` int(11) NOT NULL default '1',
  `updatets` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `src` int(11) NOT NULL,
  KEY `deviceid` (`deviceid`),
  CONSTRAINT `info_ibfk_1` FOREIGN KEY (`deviceid`) REFERENCES `devicemaster` (`deviceid`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Create table `markup`
--

CREATE TABLE `markup` (
  `deviceid` int(11) default NULL,
  `capabilityname` varchar(25) NOT NULL,
  `capabilityvalue` varchar(255) default NULL,
  `version` int(11) NOT NULL default '1',
  `updatets` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `src` int(11) NOT NULL,
  KEY `deviceid` (`deviceid`),
  CONSTRAINT `markup_ibfk_1` FOREIGN KEY (`deviceid`) REFERENCES `devicemaster` (`deviceid`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Create table `iphone`
--

CREATE TABLE `iphone` (
  `deviceid` int(11) default NULL,
  `capabilityname` varchar(25) NOT NULL,
  `capabilityvalue` varchar(255) default NULL,
  `version` int(11) NOT NULL default '1',
  `updatets` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `src` int(11) NOT NULL,
  KEY `deviceid` (`deviceid`),
  CONSTRAINT `iphone_ibfk_1` FOREIGN KEY (`deviceid`) REFERENCES `devicemaster` (`deviceid`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Create table `j2me`
--

CREATE TABLE `j2me` (
  `deviceid` int(11) default NULL,
  `capabilityname` varchar(25) NOT NULL,
  `capabilityvalue` varchar(255) default NULL,
  `version` int(11) NOT NULL default '1',
  `updatets` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `src` int(11) NOT NULL,
  KEY `deviceid` (`deviceid`),
  CONSTRAINT `j2me_ibfk_1` FOREIGN KEY (`deviceid`) REFERENCES `devicemaster` (`deviceid`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


--
-- Create table `blackberry`
--

CREATE TABLE `blackberry` (
  `deviceid` int(11) default NULL,
  `capabilityname` varchar(25) NOT NULL,
  `capabilityvalue` varchar(255) default NULL,
  `version` int(11) NOT NULL default '1',
  `updatets` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `src` int(11) NOT NULL,
  KEY `deviceid` (`deviceid`),
  CONSTRAINT `blackberry_ibfk_1` FOREIGN KEY (`deviceid`) REFERENCES `devicemaster` (`deviceid`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



--
-- Create table `brew`
--

CREATE TABLE `brew` (
  `deviceid` int(11) default NULL,
  `capabilityname` varchar(25) NOT NULL,
  `capabilityvalue` varchar(255) default NULL,
  `version` int(11) NOT NULL default '1',
  `updatets` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `src` int(11) NOT NULL,
  KEY `deviceid` (`deviceid`),
  CONSTRAINT `brew_ibfk_1` FOREIGN KEY (`deviceid`) REFERENCES `devicemaster` (`deviceid`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


--
-- Create table `windows`
--

CREATE TABLE `windows` (
  `deviceid` int(11) default NULL,
  `capabilityname` varchar(25) NOT NULL,
  `capabilityvalue` varchar(255) default NULL,
  `version` int(11) NOT NULL default '1',
  `updatets` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `src` int(11) NOT NULL,
  KEY `deviceid` (`deviceid`),
  CONSTRAINT `windows_ibfk_1` FOREIGN KEY (`deviceid`) REFERENCES `devicemaster` (`deviceid`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


--
-- Create table `newdevices`
--

CREATE TABLE `newdevices` (
  `id` int(11) NOT NULL auto_increment,
  `useragent` varchar(200) NOT NULL,
  `createts` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


--
-- Create table `populardevices`
--

CREATE TABLE `populardevices` (
  `id` int(11) NOT NULL auto_increment,
  `useragent` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


--
-- Create table `updatehistory`
--

CREATE TABLE `updatehistory` (
  `id` int(11) NOT NULL auto_increment,
  `src` int(11) NOT NULL,
  `filename` varchar(100) default NULL,
  `updatets` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


--
-- Create table `exporthistory`
--

CREATE TABLE `exporthistory` (
  `id` int(11) NOT NULL auto_increment,
  `expfilename` varchar(50) NOT NULL,
  `createts` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


--
-- Create table `clientupdatehistory`
--

CREATE TABLE `clientupdatehistory` (
  `id` int(11) NOT NULL auto_increment,
  `clientid` varchar(50) default NULL,
  `expid` int(11) default NULL,
  PRIMARY KEY  (`id`),
  KEY `expid` (`expid`),
  CONSTRAINT `clientupdatehistory_ibfk_1` FOREIGN KEY (`expid`) REFERENCES `exporthistory` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Create table `datasrcmaster`
--

CREATE TABLE `datasrcmaster` (
  `datasrctype` varchar(25) NOT NULL,
  `datasrcid` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;






--
-- Create table `metadata`
--

CREATE TABLE `metadata` (
  `id` int(11) NOT NULL auto_increment,
  `capabilitygroup` varchar(50) NOT NULL,
  `capabilityname` varchar(50) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


-- get_device_info view for kony reports data

CREATE VIEW get_device_info
(
   DEVICEID,
   MANUFACTURER,
   MODEL,
   PLATFORM
)
AS
     SELECT t2.deviceid AS deviceid,
            (SELECT COALESCE(t1.capabilityvalue, '') AS manufacturer  FROM info t1  WHERE t1.capabilityname like 'manufacturer' AND t1.deviceid = t2.deviceid limit 2) AS manufacturer,
            (SELECT COALESCE(t1.capabilityvalue, '') AS model        FROM info t1  WHERE t1.capabilityname like 'model'        AND t1.deviceid = t2.deviceid limit 2) AS model,
            (SELECT COALESCE(t1.capabilityvalue, '') AS platform     FROM info t1  WHERE t1.capabilityname like 'platform'     AND t1.deviceid = t2.deviceid limit 2) AS platform
       FROM info t2 GROUP BY t2.deviceid;
       



-- Additional Unique constraints added for device data stability

ALTER TABLE info ADD UNIQUE INDEX infostable (deviceid, capabilityname);
ALTER TABLE markup ADD UNIQUE INDEX markupstable (deviceid, capabilityname);
ALTER TABLE blackberry ADD UNIQUE INDEX blackberrystable (deviceid, capabilityname);
ALTER TABLE brew ADD UNIQUE INDEX brewstable (deviceid, capabilityname);
ALTER TABLE iphone ADD UNIQUE INDEX iphonestable (deviceid, capabilityname);
ALTER TABLE j2me ADD UNIQUE INDEX j2mestable (deviceid, capabilityname);
ALTER TABLE windows ADD UNIQUE INDEX windowsstable (deviceid, capabilityname);

-- version veiw for device data

create view version(tablename,mindeviceid,maxdeviceid,version) as 
select 'devicemaster',min(deviceid),max(deviceid),version from devicemaster group by version union
select 'info',min(deviceid),max(deviceid),version from info group by version union
select 'markup',min(deviceid),max(deviceid),version from markup group by version;


