-- Kony Device DB schema script
--
-- DEVICEMASTER  (Table) 
--
CREATE TABLE DEVICEMASTER
(
  DEVICEID      NUMBER(10)                      NOT NULL,
  USERAGENT     VARCHAR2(255 CHAR)              NOT NULL,
  RCIDENTIFIER  VARCHAR2(255 CHAR),
  PRIMARYSRC    NUMBER(10)                      NOT NULL,
  SECONDARYSRC  NUMBER(10),
  VERSION       NUMBER(10)                      DEFAULT '1'                   NOT NULL,
  CREATETS      DATE                            DEFAULT SYSDATE               NOT NULL,
  UPDATETS      DATE                            DEFAULT to_date('01-JAN-70 00:00:00', 'dd-MON-yy hh24:mi:ss') NOT NULL
)
TABLESPACE ${KONY_SERVER_DATA_TABLESPACE}  ;


--
-- INFO  (Table) 
--
CREATE TABLE INFO
(
  DEVICEID         NUMBER(10),
  CAPABILITYNAME   VARCHAR2(25 CHAR)            NOT NULL,
  CAPABILITYVALUE  VARCHAR2(255 CHAR),
  VERSION          NUMBER(10)                   DEFAULT '1'                   NOT NULL,
  UPDATETS         DATE                         DEFAULT SYSDATE               NOT NULL,
  SRC              NUMBER(10)                   NOT NULL
)
TABLESPACE ${KONY_SERVER_DATA_TABLESPACE}  ;


--
-- MARKUP  (Table) 
--
CREATE TABLE MARKUP
(
  DEVICEID         NUMBER(10),
  CAPABILITYNAME   VARCHAR2(25 CHAR)            NOT NULL,
  CAPABILITYVALUE  VARCHAR2(255 CHAR),
  VERSION          NUMBER(10)                   DEFAULT '1'                   NOT NULL,
  UPDATETS         DATE                         DEFAULT SYSDATE               NOT NULL,
  SRC              NUMBER(10)                   NOT NULL
)
TABLESPACE ${KONY_SERVER_DATA_TABLESPACE}  ;


--
-- IPHONE  (Table) 
--
CREATE TABLE IPHONE
(
  DEVICEID         NUMBER(10),
  CAPABILITYNAME   VARCHAR2(25 CHAR)            NOT NULL,
  CAPABILITYVALUE  VARCHAR2(255 CHAR),
  VERSION          NUMBER(10)                   DEFAULT '1'                   NOT NULL,
  UPDATETS         DATE                         DEFAULT SYSDATE               NOT NULL,
  SRC              NUMBER(10)                   NOT NULL
)
TABLESPACE ${KONY_SERVER_DATA_TABLESPACE}  ;


--
-- J2ME  (Table) 
--
CREATE TABLE J2ME
(
  DEVICEID         NUMBER(10),
  CAPABILITYNAME   VARCHAR2(25 CHAR)            NOT NULL,
  CAPABILITYVALUE  VARCHAR2(255 CHAR),
  VERSION          NUMBER(10)                   DEFAULT '1'                   NOT NULL,
  UPDATETS         DATE                         DEFAULT SYSDATE               NOT NULL,
  SRC              NUMBER(10)                   NOT NULL
)
TABLESPACE ${KONY_SERVER_DATA_TABLESPACE}  ;


--
-- BLACKBERRY  (Table) 
--
CREATE TABLE BLACKBERRY
(
  DEVICEID         NUMBER(10),
  CAPABILITYNAME   VARCHAR2(25 CHAR)            NOT NULL,
  CAPABILITYVALUE  VARCHAR2(255 CHAR),
  VERSION          NUMBER(10)                   DEFAULT '1'                   NOT NULL,
  UPDATETS         DATE                         DEFAULT SYSDATE               NOT NULL,
  SRC              NUMBER(10)                   NOT NULL
)
TABLESPACE ${KONY_SERVER_DATA_TABLESPACE}  ;


--
-- BREW  (Table) 
--
CREATE TABLE BREW
(
  DEVICEID         NUMBER(10),
  CAPABILITYNAME   VARCHAR2(25 CHAR)            NOT NULL,
  CAPABILITYVALUE  VARCHAR2(255 CHAR),
  VERSION          NUMBER(10)                   DEFAULT '1'                   NOT NULL,
  UPDATETS         DATE                         DEFAULT SYSDATE               NOT NULL,
  SRC              NUMBER(10)                   NOT NULL
)
TABLESPACE ${KONY_SERVER_DATA_TABLESPACE}  ;




--
-- WINDOWS  (Table) 
--
CREATE TABLE WINDOWS
(
  DEVICEID         NUMBER(10),
  CAPABILITYNAME   VARCHAR2(25 CHAR)            NOT NULL,
  CAPABILITYVALUE  VARCHAR2(255 CHAR),
  VERSION          NUMBER(10)                   DEFAULT '1'                   NOT NULL,
  UPDATETS         DATE                         DEFAULT SYSDATE               NOT NULL,
  SRC              NUMBER(10)                   NOT NULL
)
TABLESPACE ${KONY_SERVER_DATA_TABLESPACE}  ;


--
-- NEWDEVICES  (Table) 
--
CREATE TABLE NEWDEVICES
(
  ID         NUMBER(10)                         NOT NULL,
  USERAGENT  VARCHAR2(200 CHAR)                 NOT NULL,
  CREATETS   DATE                               DEFAULT SYSDATE               NOT NULL
)
TABLESPACE ${KONY_SERVER_DATA_TABLESPACE}  ;


--
-- POPULARDEVICES  (Table) 
--
CREATE TABLE POPULARDEVICES
(
  ID         NUMBER(10)                         NOT NULL,
  USERAGENT  VARCHAR2(255 CHAR)                 NOT NULL
)
TABLESPACE ${KONY_SERVER_DATA_TABLESPACE}  ;

--
-- UPDATEHISTORY  (Table) 
--
CREATE TABLE UPDATEHISTORY
(
  ID        NUMBER(10)                          NOT NULL,
  SRC       NUMBER(10)                          NOT NULL,
  FILENAME  VARCHAR2(100 CHAR),
  UPDATETS  DATE                                NOT NULL
)
TABLESPACE ${KONY_SERVER_DATA_TABLESPACE}  ;



--
-- DEVICEID_6  (Index) 
--
CREATE INDEX DEVICEID_6 ON WINDOWS
(DEVICEID)
TABLESPACE ${KONY_SERVER_INDEX_TABLESPACE} ;


--
-- PRIMARY_5  (Index) 
--
CREATE UNIQUE INDEX PRIMARY_5 ON POPULARDEVICES
(ID)
TABLESPACE ${KONY_SERVER_INDEX_TABLESPACE} ;


--
-- PRIMARY_4  (Index) 
--
CREATE UNIQUE INDEX PRIMARY_4 ON NEWDEVICES
(ID)
TABLESPACE ${KONY_SERVER_INDEX_TABLESPACE} ;


--
-- DEVICEID_5  (Index) 
--
CREATE INDEX DEVICEID_5 ON MARKUP
(DEVICEID)
TABLESPACE ${KONY_SERVER_INDEX_TABLESPACE} ;


--
-- DEVICEID_4  (Index) 
--
CREATE INDEX DEVICEID_4 ON J2ME
(DEVICEID)
TABLESPACE ${KONY_SERVER_INDEX_TABLESPACE} ;


--
-- DEVICEID_3  (Index) 
--
CREATE INDEX DEVICEID_3 ON IPHONE
(DEVICEID)
TABLESPACE ${KONY_SERVER_INDEX_TABLESPACE} ;


--
-- DEVICEID_2  (Index) 
--
CREATE INDEX DEVICEID_2 ON INFO
(DEVICEID)
TABLESPACE ${KONY_SERVER_INDEX_TABLESPACE} ;


--
-- PRIMARY_7  (Index) 
--
CREATE UNIQUE INDEX PRIMARY_7 ON DEVICEMASTER
(DEVICEID)
TABLESPACE ${KONY_SERVER_INDEX_TABLESPACE} ;




--
-- DEVICEID_1  (Index) 
--
CREATE INDEX DEVICEID_1 ON BREW
(DEVICEID)
TABLESPACE ${KONY_SERVER_INDEX_TABLESPACE} ;


--
-- DEVICEID  (Index) 
--
CREATE INDEX DEVICEID ON BLACKBERRY
(DEVICEID)
TABLESPACE ${KONY_SERVER_INDEX_TABLESPACE} ;


-- 
-- Non Foreign Key Constraints for Table DEVICEMASTER 
-- 
ALTER TABLE DEVICEMASTER ADD (
  CONSTRAINT PRIMARY_7
  PRIMARY KEY
  (DEVICEID)
  USING INDEX PRIMARY_7);


-- 
-- Non Foreign Key Constraints for Table NEWDEVICES 
-- 
ALTER TABLE NEWDEVICES ADD (
  CONSTRAINT PRIMARY_4
  PRIMARY KEY
  (ID)
  USING INDEX PRIMARY_4);


-- 
-- Non Foreign Key Constraints for Table POPULARDEVICES 
-- 
ALTER TABLE POPULARDEVICES ADD (
  CONSTRAINT PRIMARY_5
  PRIMARY KEY
  (ID)
  USING INDEX PRIMARY_5);


-- 
-- Foreign Key Constraints for Table INFO 
-- 
ALTER TABLE INFO ADD (
  CONSTRAINT INFO_IBFK_1 
  FOREIGN KEY (DEVICEID) 
  REFERENCES DEVICEMASTER (DEVICEID));


-- 
-- Foreign Key Constraints for Table MARKUP 
-- 
ALTER TABLE MARKUP ADD (
  CONSTRAINT MARKUP_IBFK_1 
  FOREIGN KEY (DEVICEID) 
  REFERENCES DEVICEMASTER (DEVICEID));


-- 
-- Foreign Key Constraints for Table IPHONE 
-- 
ALTER TABLE IPHONE ADD (
  CONSTRAINT IPHONE_IBFK_1 
  FOREIGN KEY (DEVICEID) 
  REFERENCES DEVICEMASTER (DEVICEID));


-- 
-- Foreign Key Constraints for Table J2ME 
-- 
ALTER TABLE J2ME ADD (
  CONSTRAINT J2ME_IBFK_1 
  FOREIGN KEY (DEVICEID) 
  REFERENCES DEVICEMASTER (DEVICEID));


-- 
-- Foreign Key Constraints for Table BLACKBERRY 
-- 
ALTER TABLE BLACKBERRY ADD (
  CONSTRAINT BLACKBERRY_IBFK_1 
  FOREIGN KEY (DEVICEID) 
  REFERENCES DEVICEMASTER (DEVICEID));


-- 
-- Foreign Key Constraints for Table BREW 
-- 
ALTER TABLE BREW ADD (
  CONSTRAINT BREW_IBFK_1 
  FOREIGN KEY (DEVICEID) 
  REFERENCES DEVICEMASTER (DEVICEID));


-- 
-- Foreign Key Constraints for Table WINDOWS 
-- 
ALTER TABLE WINDOWS ADD (
  CONSTRAINT WINDOWS_IBFK_1 
  FOREIGN KEY (DEVICEID) 
  REFERENCES DEVICEMASTER (DEVICEID));


--
-- EXPORTHISTORY_ID_SEQ  (Sequence) 
--
CREATE SEQUENCE EXPORTHISTORY_ID_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20
  NOORDER;


--
-- POPULARDEVICES_ID_SEQ  (Sequence) 
--
CREATE SEQUENCE POPULARDEVICES_ID_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20
  NOORDER;


--
-- CLIENTUPDATEHISTORY_ID_SEQ  (Sequence) 
--
CREATE SEQUENCE CLIENTUPDATEHISTORY_ID_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20
  NOORDER;


--
-- DEVICEMASTER_DEVICEID_SEQ  (Sequence) 
--
CREATE SEQUENCE DEVICEMASTER_DEVICEID_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20
  NOORDER;


--
-- METADATA_ID_SEQ  (Sequence) 
--
CREATE SEQUENCE METADATA_ID_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20
  NOORDER;


--
-- NEWDEVICES_ID_SEQ  (Sequence) 
--
CREATE SEQUENCE NEWDEVICES_ID_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20
  NOORDER;


--
-- TESTME_DEVICEID_SEQ  (Sequence) 
--
CREATE SEQUENCE TESTME_DEVICEID_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20
  NOORDER;


--
-- UPDATEHISTORY_ID_SEQ  (Sequence) 
--
CREATE SEQUENCE UPDATEHISTORY_ID_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20
  NOORDER;

CREATE OR REPLACE FORCE VIEW GET_DEVICE_INFO
(
   DEVICEID,
   MANUFACTURER,
   MODEL,
   PLATFORM
)
AS
     SELECT t2.deviceid AS deviceid,
            (SELECT NVL(t1.capabilityvalue, '') AS manufacturer  FROM info t1  WHERE t1.capabilityname like 'manufacturer' AND t1.deviceid = t2.deviceid AND ROWNUM < 2) AS manufacturer,
            (SELECT NVL (t1.capabilityvalue, '') AS model        FROM info t1  WHERE t1.capabilityname like 'model'        AND t1.deviceid = t2.deviceid AND ROWNUM < 2) AS model,
            (SELECT NVL (t1.capabilityvalue, '') AS platform     FROM info t1  WHERE t1.capabilityname like 'platform'     AND t1.deviceid = t2.deviceid AND ROWNUM < 2) AS platform
       FROM info t2 GROUP BY t2.deviceid;


-- Grants ----------------------------------------------------
-- The below grants are not required from 6.0 versions
-- GRANT SELECT ON INFO TO KONYLOGDB, KONYREPORTSDB;
-- GRANT SELECT ON DEVICEMASTER TO KONYLOGDB, KONYREPORTSDB;
-- GRANT SELECT ON MARKUP TO KONYLOGDB, KONYREPORTSDB;
-- GRANT SELECT ON GET_DEVICE_INFO TO KONYLOGDB, KONYREPORTSDB;

-- Additional Constraints for device data stability -----------------------------------------------
CREATE UNIQUE INDEX INFOSTABLE ON INFO (DEVICEID, CAPABILITYNAME) TABLESPACE ${KONY_SERVER_INDEX_TABLESPACE};

ALTER TABLE INFO ADD (CONSTRAINT INFOSTABLE  UNIQUE (DEVICEID, CAPABILITYNAME)  USING INDEX INFOSTABLE  ENABLE VALIDATE);

CREATE UNIQUE INDEX MARKUPSTABLE ON MARKUP (DEVICEID, CAPABILITYNAME) TABLESPACE ${KONY_SERVER_INDEX_TABLESPACE};

ALTER TABLE MARKUP ADD (CONSTRAINT MARKUPSTABLE  UNIQUE (DEVICEID, CAPABILITYNAME)  USING INDEX MARKUPSTABLE  ENABLE VALIDATE);

CREATE UNIQUE INDEX IPHONESTABLE ON IPHONE (DEVICEID, CAPABILITYNAME) TABLESPACE ${KONY_SERVER_INDEX_TABLESPACE};

ALTER TABLE IPHONE ADD (CONSTRAINT IPHONESTABLE  UNIQUE (DEVICEID, CAPABILITYNAME)  USING INDEX IPHONESTABLE  ENABLE VALIDATE);

CREATE UNIQUE INDEX J2MESTABLE ON J2ME (DEVICEID, CAPABILITYNAME) TABLESPACE ${KONY_SERVER_INDEX_TABLESPACE};

ALTER TABLE J2ME ADD (CONSTRAINT J2MESTABLE  UNIQUE (DEVICEID, CAPABILITYNAME)  USING INDEX J2MESTABLE  ENABLE VALIDATE);

CREATE UNIQUE INDEX BLACKBERRYSTABLE ON BLACKBERRY (DEVICEID, CAPABILITYNAME) TABLESPACE ${KONY_SERVER_INDEX_TABLESPACE};

ALTER TABLE BLACKBERRY ADD (CONSTRAINT BLACKBERRYSTABLE  UNIQUE (DEVICEID, CAPABILITYNAME)  USING INDEX BLACKBERRYSTABLE  ENABLE VALIDATE);

CREATE UNIQUE INDEX BREWSTABLE ON BREW (DEVICEID, CAPABILITYNAME) TABLESPACE ${KONY_SERVER_INDEX_TABLESPACE};

ALTER TABLE BREW ADD (CONSTRAINT BREWSTABLE  UNIQUE (DEVICEID, CAPABILITYNAME)  USING INDEX BREWSTABLE  ENABLE VALIDATE);

CREATE UNIQUE INDEX WINDOWSSTABLE ON WINDOWS (DEVICEID, CAPABILITYNAME) TABLESPACE ${KONY_SERVER_INDEX_TABLESPACE};

ALTER TABLE WINDOWS ADD (CONSTRAINT WINDOWSSTABLE  UNIQUE (DEVICEID, CAPABILITYNAME)  USING INDEX WINDOWSSTABLE  ENABLE VALIDATE);

-- version view for device data

create view version(tablename,mindeviceid,maxdeviceid,version) as 
select 'devicemaster',min(deviceid),max(deviceid),version from devicemaster group by version union
select 'info',min(deviceid),max(deviceid),version from info group by version union
select 'markup',min(deviceid),max(deviceid),version from markup group by version;

CREATE TABLE build_version (
  build_version varchar2(255),
  build_date date
) TABLESPACE ${KONY_SERVER_DATA_TABLESPACE} ;

insert  into build_version(build_version,build_date) values ('#SERVER_BUILD_VERSION#',sysdate);

commit;