/****** Kony Device DB schema script ******/
/****** Object:  Table [dbo].[DEVICEMASTER]    Script Date: 08/24/2012 17:19:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[DEVICEMASTER](
	[DEVICEID] [numeric](10, 0) IDENTITY(1,1) NOT NULL,
	[USERAGENT] [varchar](1020) NOT NULL,
	[RCIDENTIFIER] [varchar](1020) NULL,
	[PRIMARYSRC] [numeric](10, 0) NOT NULL,
	[SECONDARYSRC] [numeric](10, 0) NULL,
	[VERSION] [numeric](10, 0) NOT NULL,
	[CREATETS] [datetime2](0) NOT NULL,
	[UPDATETS] [datetime2](0) NOT NULL,
 CONSTRAINT [PRIMARY_7] PRIMARY KEY CLUSTERED 
(
	[DEVICEID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

/****** Object:  Default [DF__DEVICEMAS__VERSI__7F60ED59]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[DEVICEMASTER] ADD  DEFAULT ('1') FOR [VERSION]
GO
/****** Object:  Default [DF__DEVICEMAS__CREAT__00551192]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[DEVICEMASTER] ADD  DEFAULT (sysdatetime()) FOR [CREATETS]
GO
/****** Object:  Default [DF_DEVICEMASTER_UPDATETS]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[DEVICEMASTER] ADD  CONSTRAINT [DF_DEVICEMASTER_UPDATETS]  DEFAULT (sysdatetime()) FOR [UPDATETS]
GO



/****** Object:  Table [dbo].[INFO]    Script Date: 08/24/2012 17:19:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[INFO](
	[DEVICEID] [numeric](10, 0) NULL,
	[CAPABILITYNAME] [varchar](100) NOT NULL,
	[CAPABILITYVALUE] [varchar](1020) NULL,
	[VERSION] [numeric](10, 0) NOT NULL,
	[UPDATETS] [datetime2](0) NOT NULL,
	[SRC] [numeric](10, 0) NOT NULL
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

/****** Object:  ForeignKey [INFO_IBFK_1]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[INFO]  WITH NOCHECK ADD  CONSTRAINT [INFO_IBFK_1] FOREIGN KEY([DEVICEID])
REFERENCES [dbo].[DEVICEMASTER] ([DEVICEID])
GO
ALTER TABLE [dbo].[INFO] CHECK CONSTRAINT [INFO_IBFK_1]
GO

/****** Object:  Default [DF__INFO__VERSION__0425A276]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[INFO] ADD  DEFAULT ('1') FOR [VERSION]
GO
/****** Object:  Default [DF__INFO__UPDATETS__0519C6AF]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[INFO] ADD  DEFAULT (sysdatetime()) FOR [UPDATETS]
GO


/****** Object:  Table [dbo].[MARKUP]    Script Date: 08/24/2012 17:19:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[MARKUP](
	[DEVICEID] [numeric](10, 0) NULL,
	[CAPABILITYNAME] [varchar](100) NOT NULL,
	[CAPABILITYVALUE] [varchar](1020) NULL,
	[VERSION] [numeric](10, 0) NOT NULL,
	[UPDATETS] [datetime2](0) NOT NULL,
	[SRC] [numeric](10, 0) NOT NULL
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

/****** Object:  ForeignKey [MARKUP_IBFK_1]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[MARKUP]  WITH NOCHECK ADD  CONSTRAINT [MARKUP_IBFK_1] FOREIGN KEY([DEVICEID])
REFERENCES [dbo].[DEVICEMASTER] ([DEVICEID])
GO
ALTER TABLE [dbo].[MARKUP] CHECK CONSTRAINT [MARKUP_IBFK_1]
GO

/****** Object:  Default [DF__MARKUP__VERSION__07F6335A]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[MARKUP] ADD  DEFAULT ('1') FOR [VERSION]
GO
/****** Object:  Default [DF__MARKUP__UPDATETS__08EA5793]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[MARKUP] ADD  DEFAULT (sysdatetime()) FOR [UPDATETS]
GO


/****** Object:  Table [dbo].[WINDOWS]    Script Date: 08/24/2012 17:19:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[WINDOWS](
	[DEVICEID] [numeric](10, 0) NULL,
	[CAPABILITYNAME] [varchar](100) NOT NULL,
	[CAPABILITYVALUE] [varchar](1020) NULL,
	[VERSION] [numeric](10, 0) NOT NULL,
	[UPDATETS] [datetime2](0) NOT NULL,
	[SRC] [numeric](10, 0) NOT NULL
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

/****** Object:  ForeignKey [WINDOWS_IBFK_1]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[WINDOWS]  WITH NOCHECK ADD  CONSTRAINT [WINDOWS_IBFK_1] FOREIGN KEY([DEVICEID])
REFERENCES [dbo].[DEVICEMASTER] ([DEVICEID])
GO
ALTER TABLE [dbo].[WINDOWS] CHECK CONSTRAINT [WINDOWS_IBFK_1]
GO

/****** Object:  Default [DF__WINDOWS__VERSION__1B0907CE]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[WINDOWS] ADD  DEFAULT ('1') FOR [VERSION]
GO
/****** Object:  Default [DF__WINDOWS__UPDATET__1BFD2C07]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[WINDOWS] ADD  DEFAULT (sysdatetime()) FOR [UPDATETS]
GO


/****** Object:  Table [dbo].[J2ME]    Script Date: 08/24/2012 17:19:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[J2ME](
	[DEVICEID] [numeric](10, 0) NULL,
	[CAPABILITYNAME] [varchar](100) NOT NULL,
	[CAPABILITYVALUE] [varchar](1020) NULL,
	[VERSION] [numeric](10, 0) NOT NULL,
	[UPDATETS] [datetime2](0) NOT NULL,
	[SRC] [numeric](10, 0) NOT NULL
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

/****** Object:  ForeignKey [J2ME_IBFK_1]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[J2ME]  WITH NOCHECK ADD  CONSTRAINT [J2ME_IBFK_1] FOREIGN KEY([DEVICEID])
REFERENCES [dbo].[DEVICEMASTER] ([DEVICEID])
GO
ALTER TABLE [dbo].[J2ME] CHECK CONSTRAINT [J2ME_IBFK_1]
GO

/****** Object:  Default [DF__J2ME__VERSION__173876EA]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[J2ME] ADD  DEFAULT ('1') FOR [VERSION]
GO
/****** Object:  Default [DF__J2ME__UPDATETS__182C9B23]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[J2ME] ADD  DEFAULT (sysdatetime()) FOR [UPDATETS]
GO


/****** Object:  Table [dbo].[IPHONE]    Script Date: 08/24/2012 17:19:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[IPHONE](
	[DEVICEID] [numeric](10, 0) NULL,
	[CAPABILITYNAME] [varchar](100) NOT NULL,
	[CAPABILITYVALUE] [varchar](1020) NULL,
	[VERSION] [numeric](10, 0) NOT NULL,
	[UPDATETS] [datetime2](0) NOT NULL,
	[SRC] [numeric](10, 0) NOT NULL
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

/****** Object:  ForeignKey [IPHONE_IBFK_1]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[IPHONE]  WITH NOCHECK ADD  CONSTRAINT [IPHONE_IBFK_1] FOREIGN KEY([DEVICEID])
REFERENCES [dbo].[DEVICEMASTER] ([DEVICEID])
GO
ALTER TABLE [dbo].[IPHONE] CHECK CONSTRAINT [IPHONE_IBFK_1]
GO

/****** Object:  Default [DF__IPHONE__VERSION__1367E606]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[IPHONE] ADD  DEFAULT ('1') FOR [VERSION]
GO
/****** Object:  Default [DF__IPHONE__UPDATETS__145C0A3F]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[IPHONE] ADD  DEFAULT (sysdatetime()) FOR [UPDATETS]
GO


/****** Object:  Table [dbo].[BREW]    Script Date: 08/24/2012 17:19:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[BREW](
	[DEVICEID] [numeric](10, 0) NULL,
	[CAPABILITYNAME] [varchar](100) NOT NULL,
	[CAPABILITYVALUE] [varchar](1020) NULL,
	[VERSION] [numeric](10, 0) NOT NULL,
	[UPDATETS] [datetime2](0) NOT NULL,
	[SRC] [numeric](10, 0) NOT NULL
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

/****** Object:  ForeignKey [BREW_IBFK_1]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[BREW]  WITH NOCHECK ADD  CONSTRAINT [BREW_IBFK_1] FOREIGN KEY([DEVICEID])
REFERENCES [dbo].[DEVICEMASTER] ([DEVICEID])
GO
ALTER TABLE [dbo].[BREW] CHECK CONSTRAINT [BREW_IBFK_1]
GO

/****** Object:  Default [DF__BREW__VERSION__0F975522]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[BREW] ADD  DEFAULT ('1') FOR [VERSION]
GO
/****** Object:  Default [DF__BREW__UPDATETS__108B795B]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[BREW] ADD  DEFAULT (sysdatetime()) FOR [UPDATETS]
GO


/****** Object:  Table [dbo].[BLACKBERRY]    Script Date: 08/24/2012 17:19:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[BLACKBERRY](
	[DEVICEID] [numeric](10, 0) NULL,
	[CAPABILITYNAME] [varchar](100) NOT NULL,
	[CAPABILITYVALUE] [varchar](1020) NULL,
	[VERSION] [numeric](10, 0) NOT NULL,
	[UPDATETS] [datetime2](0) NOT NULL,
	[SRC] [numeric](10, 0) NOT NULL
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

/****** Object:  ForeignKey [BLACKBERRY_IBFK_1]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[BLACKBERRY]  WITH NOCHECK ADD  CONSTRAINT [BLACKBERRY_IBFK_1] FOREIGN KEY([DEVICEID])
REFERENCES [dbo].[DEVICEMASTER] ([DEVICEID])
GO
ALTER TABLE [dbo].[BLACKBERRY] CHECK CONSTRAINT [BLACKBERRY_IBFK_1]
GO

/****** Object:  Default [DF__BLACKBERR__VERSI__0BC6C43E]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[BLACKBERRY] ADD  DEFAULT ('1') FOR [VERSION]
GO
/****** Object:  Default [DF__BLACKBERR__UPDAT__0CBAE877]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[BLACKBERRY] ADD  DEFAULT (sysdatetime()) FOR [UPDATETS]
GO



/****** Object:  Table [dbo].[exporthistory]    Script Date: 08/24/2012 17:19:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[exporthistory](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[expfilename] [varchar](50) NOT NULL,
	[createts] [datetime] NOT NULL,
 CONSTRAINT [PK_exporthistory_id] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

/****** Object:  Default [DF__exporthis__creat__239E4DCF]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[exporthistory] ADD  DEFAULT (getdate()) FOR [createts]
GO


/****** Object:  Table [dbo].[datasrcmaster]    Script Date: 08/24/2012 17:19:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[datasrcmaster](
	[datasrctype] [varchar](25) NOT NULL,
	[datasrcid] [int] NOT NULL
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO


/****** Object:  Table [dbo].[clientupdatehistory]    Script Date: 08/24/2012 17:19:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[clientupdatehistory](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[clientid] [varchar](50) NULL,
	[expid] [int] NULL,
 CONSTRAINT [PK_clientupdatehistory_id] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

/****** Object:  Default [DF__clientupd__clien__1ED998B2]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[clientupdatehistory] ADD  DEFAULT (NULL) FOR [clientid]
GO
/****** Object:  Default [DF__clientupd__expid__1FCDBCEB]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[clientupdatehistory] ADD  DEFAULT (NULL) FOR [expid]
GO


/****** Object:  Table [dbo].[UPDATEHISTORY]    Script Date: 08/24/2012 17:19:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[UPDATEHISTORY](
	[ID] [numeric](10, 0) IDENTITY(1,1) NOT NULL,
	[SRC] [numeric](10, 0) NOT NULL,
	[FILENAME] [varchar](400) NULL,
	[UPDATETS] [datetime2](0) NOT NULL
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

/****** Object:  Default [DF_UPDATEHISTORY_UPDATETS]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[UPDATEHISTORY] ADD  CONSTRAINT [DF_UPDATEHISTORY_UPDATETS]  DEFAULT (sysdatetime()) FOR [UPDATETS]
GO


/****** Object:  Table [dbo].[POPULARDEVICES]    Script Date: 08/24/2012 17:19:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[POPULARDEVICES](
	[ID] [numeric](10, 0) IDENTITY(1,1) NOT NULL,
	[USERAGENT] [varchar](1020) NOT NULL,
 CONSTRAINT [PRIMARY_5] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO


/****** Object:  Table [dbo].[NEWDEVICES]    Script Date: 08/24/2012 17:19:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[NEWDEVICES](
	[ID] [numeric](10, 0) IDENTITY(1,1) NOT NULL,
	[USERAGENT] [varchar](800) NOT NULL,
	[CREATETS] [datetime2](0) NOT NULL,
 CONSTRAINT [PRIMARY_4] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

/****** Object:  Default [DF__NEWDEVICE__CREAT__286302EC]    Script Date: 08/24/2012 17:19:16 ******/
ALTER TABLE [dbo].[NEWDEVICES] ADD  DEFAULT (sysdatetime()) FOR [CREATETS]
GO


/****** Object:  Table [dbo].[metadata]    Script Date: 08/24/2012 17:19:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[metadata](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[capabilitygroup] [varchar](50) NOT NULL,
	[capabilityname] [varchar](50) NOT NULL,
 CONSTRAINT [PK_metadata_id] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

SET ANSI_PADDING OFF
GO


CREATE VIEW [GET_DEVICE_INFO]
(
   DEVICEID,
   MANUFACTURER,
   MODEL,
   PLATFORM
)
AS
SELECT t2.deviceid AS deviceid,
            (SELECT isnull (t1.capabilityvalue, '') AS manufacturer
               FROM dbo.info t1
              WHERE     t1.capabilityname LIKE 'manufacturer'
                    AND t1.deviceid = t2.deviceid
                    AND ROWCOUNT_BIG() < 2)
               AS manufacturer,
            (SELECT isnull (t1.capabilityvalue, '') AS model
               FROM dbo.info t1
              WHERE     t1.capabilityname LIKE 'model'
                    AND t1.deviceid = t2.deviceid
                    AND ROWCOUNT_BIG() < 2)
               AS model,
            (SELECT isnull (t1.capabilityvalue, '') AS platform
               FROM dbo.info t1
              WHERE     t1.capabilityname LIKE 'platform'
                    AND t1.deviceid = t2.deviceid
                    AND ROWCOUNT_BIG() < 2)
               AS platform
       FROM dbo.info t2
   GROUP BY t2.deviceid
GO

-- version view for device data


create view version(tablename,mindeviceid,maxdeviceid,version) as 
select 'devicemaster',min(deviceid),max(deviceid),version from devicemaster group by version union
select 'info',min(deviceid),max(deviceid),version from info group by version union
select 'markup',min(deviceid),max(deviceid),version from markup group by version
go

CREATE TABLE [dbo].[build_version] (
  [build_version] [VARCHAR] (255)  ,
  [build_date] [datetime2]
)
GO

insert into dbo.build_version (build_version, build_date) values ('5.0.6 GA',CURRENT_TIMESTAMP)
GO