CREATE TABLE webapp
  (
     webapp_id      NUMBER(19) NOT NULL,
     webapp_name    VARCHAR2(64) UNIQUE,
     webapp_version VARCHAR2(16),
     webapp_zip_name    VARCHAR2(64),
	 webapp_channel    VARCHAR(128),
     webapp_properties  CLOB,
     created_by     VARCHAR2(64),
     created_date   TIMESTAMP(6),
     updated_by     VARCHAR2(64),
     updated_date   TIMESTAMP(6),
     col1 		VARCHAR2(64),
     col2 		VARCHAR2(64),
     col3 		VARCHAR2(64),
     col4 		VARCHAR2(64),
     col5 		VARCHAR2(64),
     PRIMARY KEY(webapp_id) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
  )tablespace ${KONY_SERVER_DATA_TABLESPACE};

-- Generate ID using sequence and trigger
CREATE SEQUENCE webapp_seq START WITH 1 INCREMENT BY 1 MAXVALUE 999999999999999999999999 MINVALUE 1 NOCYCLE CACHE 20;

CREATE OR REPLACE TRIGGER webapp_seq_tr
 BEFORE INSERT ON webapp FOR EACH ROW
 WHEN (NEW.webapp_id IS NULL)
BEGIN
 SELECT webapp_seq.NEXTVAL INTO :NEW.webapp_id FROM DUAL;
END;
/
  
CREATE TABLE webapp_asset
  (
     webapp_asset_id      NUMBER(19) NOT NULL,
     webapp_asset_content BLOB,
     webapp_asset_name    VARCHAR2(64),
     webapp_asset_type    VARCHAR2(16) DEFAULT 'JAR',
     created_by           VARCHAR2(64),
     created_date         TIMESTAMP(6),
     updated_by           VARCHAR2(64),
     updated_date         TIMESTAMP(6),
     col1 		VARCHAR2(64),
     col2 		VARCHAR2(64),
     col3 		VARCHAR2(64),
     col4 		VARCHAR2(64),
     col5 		VARCHAR2(64),
     PRIMARY KEY (webapp_asset_id) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
  )tablespace ${KONY_SERVER_DATA_TABLESPACE};

-- Generate ID using sequence and trigger
CREATE SEQUENCE webapp_asset_seq START WITH 1 INCREMENT BY 1 MAXVALUE 999999999999999999999999 MINVALUE 1 NOCYCLE CACHE 20;

CREATE OR REPLACE TRIGGER webapp_asset_seq_tr
 BEFORE INSERT ON webapp_asset FOR EACH ROW
 WHEN (NEW.webapp_asset_id IS NULL)
BEGIN
 SELECT webapp_asset_seq.NEXTVAL INTO :NEW.webapp_asset_id FROM DUAL;
END;
/ 
  
CREATE TABLE webapp_content
  (
     webapp_content_id   NUMBER(19) NOT NULL,
     webapp_id           NUMBER(19) NOT NULL,
     webapp_content_part BLOB,
     webapp_resource_path      VARCHAR2(255) NOT NULL,
     created_by     VARCHAR2(64),
     created_date   TIMESTAMP(6),
     updated_by     VARCHAR2(64),
     updated_date   TIMESTAMP(6),
     col1 		VARCHAR2(64),
     col2 		VARCHAR2(64),
     col3 		VARCHAR2(64),
     col4 		VARCHAR2(64),
     col5 		VARCHAR2(64),
     CONSTRAINT fk_webapp_content_id FOREIGN KEY (webapp_id) REFERENCES webapp(webapp_id) ON DELETE CASCADE,
     PRIMARY KEY (webapp_content_id) USING INDEX tablespace ${KONY_SERVER_INDEX_TABLESPACE}
  )tablespace ${KONY_SERVER_DATA_TABLESPACE};

create index idx_webapp_content_webapp_id on webapp_content(webapp_id) tablespace ${KONY_SERVER_INDEX_TABLESPACE};
  
-- Generate ID using sequence and trigger
CREATE SEQUENCE webapp_content_seq START WITH 1 INCREMENT BY 1 MAXVALUE 999999999999999999999999 MINVALUE 1 NOCYCLE CACHE 20;

CREATE OR REPLACE TRIGGER webapp_content_seq_tr
 BEFORE INSERT ON webapp_content FOR EACH ROW
 WHEN (NEW.webapp_content_id IS NULL)
BEGIN
 SELECT webapp_content_seq.NEXTVAL INTO :NEW.webapp_content_id FROM DUAL;
END;
/

CREATE TABLE webapp_asset_info
  (
     webapp_id       NUMBER(19) NOT NULL,
     webapp_asset_id NUMBER(19) NOT NULL,
     CONSTRAINT fk_asset_info_webapp_id FOREIGN KEY (webapp_id) REFERENCES webapp(webapp_id),
     CONSTRAINT fk_asset_info_webapp_asset_id FOREIGN KEY (webapp_asset_id) REFERENCES webapp_asset(webapp_asset_id)
  )tablespace ${KONY_SERVER_DATA_TABLESPACE};
  
create index idx_asset_info_webapp_id on webapp_asset_info(webapp_id) tablespace ${KONY_SERVER_INDEX_TABLESPACE};
create index idx_asset_info_webapp_asset_id on webapp_asset_info(webapp_asset_id) tablespace ${KONY_SERVER_INDEX_TABLESPACE};