-- Note: Replace schema names ("KONYREPORTS", "KONYADMIN"), database name (<konydb>), username (<username>) and password <password> with your actual values.
-- Follow the below command to run the script using DB2 command line client with ";" as line terminator/delimiter.
--     db2 -td';' -vf 01.konyreports-db2-upg-6.0.3-6.0.3.1.sql
-- Connect to database using below command
CONNECT TO <konydb> user <username> using <password>;
SET CURRENT SCHEMA "KONYREPORTS";
-- Reports metadata tables (moved from konyadmin database)
CREATE TABLE dw_keys_request (
   	request_key  	bigint		GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
   	rid          	VARCHAR(255)   	NOT NULL,
   	eid          	VARCHAR(255)    NOT NULL,
   	ts    	timestamp       NOT NULL,
   	insert_date  	TIMESTAMP    	NOT NULL DEFAULT ,
   	col1 varchar(255)  ,
	col2 varchar(255) ,
	col3 varchar(255) ,
	col4 varchar(255) ,
	col5 varchar(255) ,
	created_by 		VARCHAR(255) ,	
	created_date 		timestamp ,	
	updated_by 		VARCHAR(255) ,
	updated_date 		timestamp ,
   	constraint pk_dw_keys_request PRIMARY KEY (request_key),
	CONSTRAINT uk_dw_keys_request UNIQUE (rid, eid, ts)
);
CREATE TABLE dw_keys_session (
   	session_key  bigint		GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
   	sid          varchar(255)   	NOT NULL,
   	hash_code    varchar(255)	NOT NULL,
   	insert_date  TIMESTAMP   	NOT NULL	DEFAULT ,
   	col1 varchar(255)  ,
	col2 varchar(255) ,
	col3 varchar(255) ,
	col4 varchar(255) ,
	col5 varchar(255) ,
	created_by 		VARCHAR(255) ,	
	created_date 		timestamp ,	
	updated_by 		VARCHAR(255) ,
	updated_date 		timestamp ,
   	constraint pk_dw_keys_session PRIMARY KEY (session_key),
	CONSTRAINT uk_dw_keys_session UNIQUE (sid, hash_code)
);
CREATE TABLE geolocations_ip4 (
   	startIpNum  VARCHAR(15),
   	endIpNum    VARCHAR(15),
   	startIpInt  BIGINT   NOT NULL,
   	endIpInt    BIGINT   DEFAULT 0 NOT NULL,
   	country     VARCHAR(2),
   	region      VARCHAR(2),
   	city        VARCHAR(255),
   	postalCode  VARCHAR(6),
   	latitude    DECIMAL(8,5),
   	longitude   DECIMAL(8,5),
   	dmaCode     VARCHAR(3),
   	areaCode    VARCHAR(3),
   	IPspatial   varchar(255)        NOT NULL,
   	col1 varchar(255)  ,
	col2 varchar(255) ,
	col3 varchar(255) ,
	col4 varchar(255) ,
	col5 varchar(255) ,
	created_by 		VARCHAR(255) ,	
	created_date 		timestamp ,	
	updated_by 		VARCHAR(255) ,
	updated_date 		timestamp,
    CONSTRAINT pk_geolocations_ip4 PRIMARY KEY (startIpInt, endIpInt)	
);
CREATE INDEX ux_geolocations_ip4_spatial
   ON geolocations_ip4 (IPspatial ASC);
CREATE TABLE crpt_owner (
   	id       		bigint		GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
   	kaid          varchar(255)    NOT NULL,
   	eid           VARCHAR(255)    NOT NULL,
   	aid           VARCHAR(255)	NOT NULL,
   	dw_table_name VARCHAR(255)  	NOT NULL,
  	jrs_domain    VARCHAR(255),
   	col1 varchar(255)  ,
	col2 varchar(255) ,
	col3 varchar(255) ,
	col4 varchar(255) ,
	col5 varchar(255) ,
	created_by 		VARCHAR(255) ,	
	created_date 		timestamp ,	
	updated_by 		VARCHAR(255) ,
	updated_date 		timestamp ,
   	constraint pk_crpt_owner PRIMARY KEY (id),
	CONSTRAINT uk_crpt_owner UNIQUE (kaid, eid, aid)	
);
CREATE TABLE crpt_metric (
	id       		bigint		GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
   	owner_id      bigint      NOT NULL,
   	name          VARCHAR(255)   	NOT NULL,
   	mtype         VARCHAR(255)   	NOT NULL,
   	dtype         VARCHAR(255)   	NOT NULL,
   	aggr_func     VARCHAR(255),
   	is_deleted    char(1) 				,
   	dw_column_name	VARCHAR(255)   	NOT NULL,
   	col1 varchar(255)  ,
	col2 varchar(255) ,
	col3 varchar(255) ,
	col4 varchar(255) ,
	col5 varchar(255) ,
	created_by 		VARCHAR(255) ,	
	created_date 		timestamp ,	
	updated_by 		VARCHAR(255) ,
	updated_date 		timestamp ,
   	constraint pk_crpt_metric PRIMARY KEY (id),
	CONSTRAINT fk_crpt_metric_owner_id FOREIGN KEY (owner_id) REFERENCES crpt_owner (id)
);
CREATE INDEX idx_crpt_metric_owner_id
   ON crpt_metric (owner_id ASC);
CREATE TABLE crpt_master_info (
   	id       		bigint		GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
   	datatype      VARCHAR(20)		NOT NULL,
   	col_prefix    VARCHAR(20)	    NOT NULL,
   	col_count     SMALLINT		NOT NULL,
   	col_metadata	VARCHAR(255)	NOT NULL,
   	jas_datatype  VARCHAR(255),
   	col1 varchar(255)  ,
	col2 varchar(255) ,
	col3 varchar(255) ,
	col4 varchar(255) ,
	col5 varchar(255) ,
	created_by 		VARCHAR(255) ,	
	created_date 		timestamp ,	
	updated_by 		VARCHAR(255) ,
	updated_date 		timestamp ,
   	constraint pk_crpt_master_info PRIMARY KEY (id)
);
CREATE TABLE reports_settings (
  id       		bigint		GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
  config_name varchar(255) NOT NULL,
  config_value varchar(255) NOT NULL,
  config_type varchar(1000) NOT NULL,
  selected char(1) ,
  col1 varchar(255)  ,
  col2 varchar(255) ,
  col3 varchar(255) ,
  col4 varchar(255) ,
  col5 varchar(255) ,
  created_by 		VARCHAR(255) ,	
  created_date 		timestamp ,	
  updated_by 		VARCHAR(255) ,
  updated_date 		timestamp ,
  constraint pk_reports_settings PRIMARY KEY (id),
  CONSTRAINT uk_reports_settings_name UNIQUE (config_name)
);
CREATE TABLE build_version (
   	build_version VARCHAR(255),
	build_date 	timestamp
);
insert  into build_version(build_version,build_date) values ('MIDDLEWARE-GA-6.0.3.1', CURRENT_TIMESTAMP);
alter TABLE service_mapping alter COLUMN menuname drop not NULL;
alter TABLE service_mapping alter COLUMN eventname drop not NULL;
alter TABLE form_mapping alter COLUMN menuname drop not NULL;
alter TABLE form_mapping alter COLUMN eventname drop not NULL;
CALL ADMIN_CMD('reorg table service_mapping');
CALL ADMIN_CMD('reorg table form_mapping');
commit;
insert into reports_settings select * from "KONYADMIN".reports_settings;
insert into dw_keys_request  select * from "KONYADMIN".dw_keys_request ;
insert into dw_keys_session  select * from "KONYADMIN".dw_keys_session ;
insert into geolocations_ip4 select * from "KONYADMIN".geolocations_ip4;
insert into crpt_owner       select * from "KONYADMIN".crpt_owner      ;
insert into crpt_metric      select * from "KONYADMIN".crpt_metric     ;
insert into crpt_master_info select * from "KONYADMIN".crpt_master_info;
commit;