-- Note: Replace schema names ("KONYREPORTS"), database name (<konydb>), username (<username>) and password <password> with your actual values.
-- This upgrade script is to reset the sequence numbers of auto incremented ids in tables which are copied from konyadmin schema.
-- Follow the below command to run the script using DB2 command line client with "@" as line terminator/delimiter for creating and running procedure.
--     db2 -td'@' -vf 02.konyreports-db2-upg-6.0.3-6.0.3.1.sql
-- Connect to database using below command
CONNECT TO <konydb> user <username> using <password> @
SET CURRENT SCHEMA "KONYREPORTS" @
CREATE OR REPLACE PROCEDURE RESET_REPORTS_SEQNOS()
  LANGUAGE SQL
  NOT DETERMINISTIC
  EXTERNAL ACTION
  MODIFIES SQL DATA
  CALLED ON NULL INPUT
  INHERIT SPECIAL REGISTERS
  OLD SAVEPOINT LEVEL
P1: BEGIN
	DECLARE max_id INTEGER default 1;
	DECLARE tempStmt VARCHAR(3000) default ''; 
	DECLARE updateStmt VARCHAR(4000) default '';
	SELECT nvl(max(request_key),0)+1 into max_id from dw_keys_request;
	SET tempStmt = 'ALTER TABLE dw_keys_request ALTER COLUMN request_key RESTART WITH '||max_id;
	PREPARE updateStmt FROM tempStmt;
	EXECUTE updateStmt;
	SELECT nvl(max(session_key),0)+1 into max_id from DW_KEYS_SESSION;
	SET tempStmt = 'ALTER TABLE dw_keys_session ALTER COLUMN session_key RESTART WITH '||max_id;
	PREPARE updateStmt FROM tempStmt;
	EXECUTE updateStmt;
	SELECT nvl(max(id),0)+1 into max_id from reports_settings;
	SET tempStmt = 'ALTER TABLE reports_settings ALTER COLUMN id RESTART WITH '||max_id;
	PREPARE updateStmt FROM tempStmt;
	EXECUTE updateStmt;
	SELECT nvl(max(id),0)+1 into max_id from custom_metrics_master;
	SET tempStmt = 'ALTER TABLE custom_metrics_master ALTER COLUMN id RESTART WITH '||max_id;
	PREPARE updateStmt FROM tempStmt;
	EXECUTE updateStmt;
	SELECT nvl(max(id),0)+1 into max_id from crpt_owner;
	SET tempStmt = 'ALTER TABLE crpt_owner ALTER COLUMN id RESTART WITH '||max_id;
	PREPARE updateStmt FROM tempStmt;
	EXECUTE updateStmt;
	SELECT nvl(max(id),0)+1 into max_id from crpt_metric;
	SET tempStmt = 'ALTER TABLE crpt_metric ALTER COLUMN id RESTART WITH '||max_id;
	PREPARE updateStmt FROM tempStmt;
	EXECUTE updateStmt;
	SELECT nvl(max(id),0)+1 into max_id from crpt_master_info;
	SET tempStmt = 'ALTER TABLE crpt_master_info ALTER COLUMN id RESTART WITH '||max_id;
	PREPARE updateStmt FROM tempStmt;
	EXECUTE updateStmt;
	COMMIT;
END P1 @
CALL "KONYREPORTS"."RESET_REPORTS_SEQNOS"() @
CALL ADMIN_CMD('reorg table reports_settings') @
CALL ADMIN_CMD('reorg table dw_keys_session') @
CALL ADMIN_CMD('reorg table dw_keys_request') @
CALL ADMIN_CMD('reorg table custom_metrics_master') @
CALL ADMIN_CMD('reorg table crpt_owner') @
CALL ADMIN_CMD('reorg table crpt_metric') @
CALL ADMIN_CMD('reorg table crpt_master_info') @
commit @