-- Note: Replace schema names ("KONYREPORTS", "KONYADMIN"), database name (<konydb>), username (<username>) and password <password> with your actual values.
-- Follow the below command to run the script using DB2 command line client with ";" as line terminator/delimiter.
--     db2 -td';' -vf 01.konyreports-db2-upg-6.0.3.2-6.5.0.sql
-- Connect to database using below command
CONNECT TO <konydb> user <username> using <password>;
SET CURRENT SCHEMA "KONYREPORTS";
insert  into build_version(build_version,build_date) values ('MIDDLEWARE-GA-6.5.0.0', CURRENT_TIMESTAMP);
CREATE TABLE "schema_version"
(
   "version_rank"    INTEGER          NOT NULL,
   "installed_rank"  INTEGER          NOT NULL,
   "version"         VARCHAR(50)      NOT NULL,
   "description"     VARCHAR(200)     NOT NULL,
   "type"            VARCHAR(20)      NOT NULL,
   "script"          VARCHAR(1000)    NOT NULL,
   "checksum"        INTEGER,
   "installed_by"    VARCHAR(100)     NOT NULL,
   "installed_on"    TIMESTAMP        DEFAULT CURRENT TIMESTAMP NOT NULL,
   "execution_time"  INTEGER          NOT NULL,
   "success"         SMALLINT         NOT NULL,
   CONSTRAINT schema_version_s CHECK ("success" in(0,1))
);
ALTER TABLE "schema_version"
   ADD CONSTRAINT "schema_version_pk"
   PRIMARY KEY ("version");
CREATE INDEX schema_version_ir_idx
   ON "schema_version" ("installed_rank" ASC);
CREATE INDEX schema_version_s_idx
   ON "schema_version" ("success" ASC);
CREATE INDEX schema_version_vr_idx
   ON "schema_version" ("version_rank" ASC);
INSERT INTO "schema_version" ("version_rank","installed_rank","version","description","type","script","checksum","installed_by","installed_on","execution_time","success")
VALUES
(
  1,
  1,
  '1',
  'db2 reports db',
  'SQL',
  'V1__db2_reports_db.sql',
  1697952625,
  'DBCLIENT',
  TIMESTAMP '2015-06-15 19:44:04.403',
  2301,
  1
);
INSERT INTO "schema_version" ("version_rank","installed_rank","version","description","type","script","checksum","installed_by","installed_on","execution_time","success")
VALUES
(
  2,
  2,
  '2',
  'db2 reports db',
  'SQL',
  'V2__db2_reports_db.sql',
  1642988876,
  'DBCLIENT',
  TIMESTAMP '2015-06-15 19:44:05.906',
  1479,
  1
);
INSERT INTO "schema_version" ("version_rank","installed_rank","version","description","type","script","checksum","installed_by","installed_on","execution_time","success")
VALUES
(
  3,
  3,
  '3',
  'db2 reports db',
  'SQL',
  'V3__db2_reports_db.sql',
  532214238,
  'DBCLIENT',
  TIMESTAMP '2015-06-15 19:44:05.968',
  41,
  1
);
create table application_events
(
	id	bigint 		GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
    bid   			varchar(255)   not null,
    mid   			varchar(255),
	awsid varchar(255) ,
	ebid	varchar(255),
	rid	varchar(255),
	kaid    		varchar(255)   not null,
    eid     		varchar(255)   not null,
    aid     		varchar(255)   not null,
	aname varchar(255) NOT NULL ,
	atype	varchar(255)  NOT NULL,
	chnl	varchar(255)   NOT NULL,
	plat	varchar(255)   NOT NULL,
	rip	varchar(255),
	did	varchar(255),
	dm    varchar(255),
	os	varchar(255),
	ua	varchar(255),
	stype	varchar(255)     Default '' NOT NULL,
	aver	varchar(255),
	kuid		varchar(255),
    ts 				timestamp     not null, 
    evttype 		varchar(100)  not null,
    formid   		varchar(255),
    widgetid   		varchar(255),
    sid   		    varchar(255) not null,
    evtsubtype   	varchar(255),
    flowtag   		varchar(255),
    request_key 	bigint,
    session_key 	bigint NOT NULL,
	metadata_var  varchar(20000),
	metadata 	clob,
	country	varchar(2),
	region	varchar(2),
	city		varchar(255),
	zip		varchar(6),
	lat		numeric(8,5),
	lon		numeric(8,5),
	dmacd     integer,
	areacd	varchar(3),
	sdktype varchar(50),
	sdkversion varchar(50),
	col1 		varchar(255),
	col2 		varchar(255),
	col3 		varchar(255),
	col4 		varchar(255),
	col5 		varchar(255),
   	constraint pk_application_events PRIMARY KEY (id),
CONSTRAINT fk_application_events_session_key FOREIGN KEY (session_key) REFERENCES middleware_sessions (session_key),
CONSTRAINT fk_application_events_request_key FOREIGN KEY (request_key) REFERENCES middleware_requests (request_key)
);
CREATE INDEX fk_application_events_session_key    ON application_events (session_key ASC);
CREATE INDEX fk_application_events_request_key    ON application_events (request_key ASC);
create table application_service_detail
(
	id	bigint 		GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
    bid   			varchar(255)   not null,
    mid   			varchar(255),
    kaid    		varchar(255)   not null,
    eid     		varchar(255)   not null,
    aid     		varchar(255)   not null,
    ts 				timestamp     not null,
    evttype 		varchar(100)  not null,
	aname 			varchar(255) NOT NULL,
	atype 			varchar(255) not null,
	plat 			varchar(255) not null,
	chnl 			varchar(255) not null,
    formid   		varchar(255), 
    widgetid   		varchar(255),
    sid   		    varchar(255)  not null,
    evtsubtype   	varchar(255),
    flowtag   		varchar(255),
    request_key 	bigint,
    session_key 	bigint NOT NULL,
    opstatus        varchar(50) NOT NULL,
    httpcode        int NOT NULL,
    resptime        int NOT NULL,
	did	varchar(255),
	dm    varchar(255),
	os	varchar(255),
	ua	varchar(255),
	aver	varchar(255),
	kuid		varchar(255),
	sdktype varchar(50),
	sdkversion varchar(50),
	col1 			varchar(255),
	col2 			varchar(255),
	col3 			varchar(255),
	col4 			varchar(255),
	col5 			varchar(255),
	constraint pk_application_service_detail PRIMARY KEY (id),
CONSTRAINT fk_application_service_detail_session_key FOREIGN KEY (session_key) REFERENCES middleware_sessions (session_key),
CONSTRAINT fk_application_service_detail_request_key FOREIGN KEY (request_key) REFERENCES middleware_requests (request_key)
)
;
CREATE INDEX fk_application_service_detail_session_key    ON application_service_detail (session_key ASC);
CREATE INDEX fk_application_service_detail_request_key   ON application_service_detail (request_key ASC);
create table application_error_detail
(
	id	bigint 		GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
    bid   			varchar(255)   not null,
    mid   			varchar(255),
    kaid    		varchar(255)   not null,
    eid     		varchar(255)   not null,
    aid     		varchar(255)   not null,
    ts 				timestamp     not null,
    evttype 		varchar(100)  not null,
	aname 			varchar(255) NOT NULL,
	atype 			varchar(255) not null,
	plat 			varchar(255) not null,
	chnl 			varchar(255) not null,
    formid   		varchar(255),
    widgetid   		varchar(255),
    sid   		    varchar(255)  not null,
    evtsubtype   	varchar(255),
    flowtag   		varchar(255),
    request_key 	bigint ,
    session_key 	bigint NOT NULL,
    errcode         varchar(50),
    errmsg          varchar(255),
    errfile         varchar (255),
    errmethod       varchar(255),
    errline         int,
	errstacktrace_var varchar(8000),
    errstacktrace   CLOB,
    errtype         varchar(255),
    iserror         smallint,
	errcustommsg_var varchar(4095),
	errcustommsg CLOB,
	errcrashreport_var varchar(8000),
	errcrashreport CLOB,
	sessionid	varchar(255),
	did	varchar(255),
	dm    varchar(255),
	os	varchar(255),
	ua	varchar(255),
	aver	varchar(255),
	kuid		varchar(255),
	sdktype varchar(50),
	sdkversion varchar(50),
	pluginverplat varchar(255),
	pluginveride varchar(2048),
	col1 		varchar(255),
	col2 		varchar(255),
	col3 		varchar(255),
	col4 		varchar(255),
	col5 		varchar(255),
	constraint pk_application_error_detail PRIMARY KEY (id),
CONSTRAINT fk_application_error_detail_session_key FOREIGN KEY (session_key) REFERENCES middleware_sessions (session_key),
CONSTRAINT fk_application_error_detail_request_key FOREIGN KEY (request_key) REFERENCES middleware_requests (request_key)
)
;
CREATE INDEX fk_application_error_detail_session_key    ON application_error_detail (session_key ASC);
CREATE INDEX fk_application_error_detail_request_key   ON application_error_detail (request_key ASC);
-- ALTER SCRIPTS FOR MIDDLEWARE REQUESTS
ALTER TABLE middleware_requests ADD COLUMN sdktype varchar(50);
ALTER TABLE middleware_requests ADD COLUMN sdkversion varchar(50) ;
ALTER TABLE middleware_requests ADD COLUMN opstatus int;
ALTER TABLE middleware_requests ADD COLUMN httpcode int;
ALTER TABLE middleware_requests ADD COLUMN errmsg varchar(4095) ;
ALTER TABLE middleware_requests ADD COLUMN errstack_var varchar(20000) ;
ALTER TABLE middleware_requests ADD COLUMN errstack CLOB ;
-- ALTER SCRIPTS FOR MIDDLEWARE SESSIONS
ALTER TABLE middleware_sessions ADD COLUMN sdktype varchar(50);
ALTER TABLE middleware_sessions ADD COLUMN sdkversion varchar(50) ;
ALTER TABLE middleware_sessions ADD COLUMN opstatus int;
ALTER TABLE middleware_sessions ADD COLUMN httpcode int;
ALTER TABLE middleware_sessions ADD COLUMN errmsg varchar(4095);
ALTER TABLE middleware_sessions ADD COLUMN errstack_var varchar(20000) ;
ALTER TABLE middleware_sessions ADD COLUMN errstack CLOB ;
-- REORG TABLES
CALL ADMIN_CMD('reorg table middleware_requests');
CALL ADMIN_CMD('reorg table middleware_sessions');
create table jrs_fusionmap_world(
id	bigint 		GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
geoname_country varchar(2),
chartentityid varchar(3),
shortname varchar(2),
longname varchar(50),
col1 		varchar(255),
col2 		varchar(255),
col3 		varchar(255),
col4 		varchar(255),
col5 		varchar(255),
constraint pk_jrs_fusionmap_world primary key(id)
)
;
insert into jrs_fusionmap_world(geoname_country,chartentityid,shortname,longname)
        select 'AG','1','AG','Antigua and Barbuda'  from sysibm.sysdummy1 union
        select 'BS','2','BS','Bahamas' from sysibm.sysdummy1 union
        select 'BB','3','BB','Barbados' from sysibm.sysdummy1 union
        select 'BZ','4','BZ','Belize' from sysibm.sysdummy1 union
        select 'CA','5','CA','Canada' from sysibm.sysdummy1 union
        select 'CR','6','CR','Costa Rica' from sysibm.sysdummy1 union
        select 'CU','7','CU','Cuba' from sysibm.sysdummy1 union
        select 'DM','8','DM','Dominica' from sysibm.sysdummy1 union
        select 'DO','9','DO','Dominican Rep.' from sysibm.sysdummy1 union
        select 'SV','10','SV','El Salvador' from sysibm.sysdummy1 union
        select 'GD','11','GD','Grenada' from sysibm.sysdummy1 union
        select 'GT','12','GT','Guatemala' from sysibm.sysdummy1 union
        select 'HT','13','HT','Haiti' from sysibm.sysdummy1 union
        select 'HN','14','HN','Honduras' from sysibm.sysdummy1 union
        select 'JM','15','JM','Jamaica' from sysibm.sysdummy1 union
        select 'MX','16','MX','Mexico' from sysibm.sysdummy1 union
        select 'NI','17','NI','Nicaragua' from sysibm.sysdummy1 union
        select 'PA','18','PA','Panama' from sysibm.sysdummy1 union
        select 'KN','19','KN','St. Kitts & Nevis' from sysibm.sysdummy1 union
        select 'LC','20','LC','St. Lucia' from sysibm.sysdummy1 union
        select 'VC','21','VC','St. Vincent & the Grenadines' from sysibm.sysdummy1 union
        select 'TT','22','TT','Trinidad & Tobago' from sysibm.sysdummy1 union
        select 'US','23','US','United States' from sysibm.sysdummy1 union
        select 'GL','24','GL','Greenland' from sysibm.sysdummy1 union
        select 'AR','25','AR','Argentina' from sysibm.sysdummy1 union
        select 'BO','26','BO','Bolivia' from sysibm.sysdummy1 union
        select 'BR','27','BR','Brazil' from sysibm.sysdummy1 union
        select 'CL','28','CL','Chile' from sysibm.sysdummy1 union
        select 'CO','29','CO','Colombia' from sysibm.sysdummy1 union
        select 'EC','30','EC','Ecuador' from sysibm.sysdummy1 union
        select 'FK','31','FK','Falkland Islands' from sysibm.sysdummy1 union
        select 'GF','32','GF','French Guiana' from sysibm.sysdummy1 union
        select 'GY','33','GY','Guyana' from sysibm.sysdummy1 union
        select 'PY','34','PY','Paraguay' from sysibm.sysdummy1 union
        select 'PE','35','PE','Peru' from sysibm.sysdummy1 union
        select 'SR','36','SR','Suriname' from sysibm.sysdummy1 union
        select 'UY','37','UY','Uruguay' from sysibm.sysdummy1 union
        select 'VE','38','VE','Venezuela' from sysibm.sysdummy1 union
        select 'DZ','39','DZ','Algeria' from sysibm.sysdummy1 union
        select 'AO','40','AO','Angola' from sysibm.sysdummy1 union
        select 'BJ','41','BJ','Benin' from sysibm.sysdummy1 union
        select 'BW','42','BW','Botswana' from sysibm.sysdummy1 union
        select 'BF','43','BF','Burkina Faso' from sysibm.sysdummy1 union
        select 'BI','44','BI','Burundi' from sysibm.sysdummy1 union
        select 'CM','45','CM','Cameroon' from sysibm.sysdummy1 union
        select 'CV','46','CV','Cape Verde' from sysibm.sysdummy1 union
        select 'CP','47','CP','Central African Republic' from sysibm.sysdummy1 union
        select 'TD','48','TD','Chad' from sysibm.sysdummy1 union
        select 'KM','49','KM','Comoros' from sysibm.sysdummy1 union
        select 'CI','50','CI','Cote d Ivoire' from sysibm.sysdummy1 union
        select 'CD','51','CD','Democratic Republic of the Congo' from sysibm.sysdummy1 union
        select 'DJ','52','DJ','Djibouti' from sysibm.sysdummy1 union
        select 'EG','53','EG','Egypt' from sysibm.sysdummy1 union
        select 'GQ','54','GQ','Equatorial Guinea' from sysibm.sysdummy1 union
        select 'ER','55','ER','Eritrea' from sysibm.sysdummy1 union
        select 'ET','56','ET','Ethiopia' from sysibm.sysdummy1 union
        select 'GA','57','GA','Gabon' from sysibm.sysdummy1 union
        select 'GH','58','GH','Ghana' from sysibm.sysdummy1 union
        select 'GN','59','GN','Guinea' from sysibm.sysdummy1 union
        select 'GW','60','GW','Guinea-Bissau' from sysibm.sysdummy1 union
        select 'KE','61','KE','Kenya' from sysibm.sysdummy1 union
        select 'LS','62','LS','Lesotho' from sysibm.sysdummy1 union
        select 'LI','63','LI','Liberia' from sysibm.sysdummy1 union
        select 'LR','64','LR','Libya' from sysibm.sysdummy1 union
        select 'MS','65','MS','Madagascar' from sysibm.sysdummy1 union
        select 'MW','66','MW','Malawi' from sysibm.sysdummy1 union
        select 'ML','67','ML','Mali' from sysibm.sysdummy1 union
        select 'MR','68','MR','Mauritania' from sysibm.sysdummy1 union
        select 'MA','69','MA','Morocco' from sysibm.sysdummy1 union
        select 'MZ','70','MZ','Mozambique' from sysibm.sysdummy1 union
        select 'NA','71','NA','Namibia' from sysibm.sysdummy1 union
        select 'NE','72','NE','Niger' from sysibm.sysdummy1 union
        select 'NG','73','NG','Nigeria' from sysibm.sysdummy1 union
        select 'RW','74','RW','Rwanda' from sysibm.sysdummy1 union
        select 'ST','75','ST','Sao Tome and Principe' from sysibm.sysdummy1 union
        select 'SN','76','SN','Senegal' from sysibm.sysdummy1 union
        select 'SC','77','SC','Seychelles' from sysibm.sysdummy1 union
        select 'SL','78','SL','Sierra Leone' from sysibm.sysdummy1 union
        select 'SO','79','SO','Somalia' from sysibm.sysdummy1 union
        select 'ZA','80','ZA','South Africa' from sysibm.sysdummy1 union
        select 'SD','81','SD','Sudan' from sysibm.sysdummy1 union
        select 'SZ','82','SZ','Swaziland' from sysibm.sysdummy1 union
        select 'TZ','83','TZ','Tanzania' from sysibm.sysdummy1 union
        select 'TG','84','TG','Togo' from sysibm.sysdummy1 union
        select 'TN','85','TN','Tunisia' from sysibm.sysdummy1 union
        select 'UG','86','UG','Uganda' from sysibm.sysdummy1 union
        select 'WA','87','WA','Western Sahara' from sysibm.sysdummy1 union
        select 'ZM','88','ZM','Zambia' from sysibm.sysdummy1 union
        select 'ZW','89','ZW','Zimbabwe' from sysibm.sysdummy1 union
        select 'GM','90','GM','Gambia' from sysibm.sysdummy1 union
        select 'CG','91','CG','Congo' from sysibm.sysdummy1 union
        select 'MI','92','MI','Mauritius' from sysibm.sysdummy1 union
        select 'AF','93','AF','Afghanistan' from sysibm.sysdummy1 union
        select 'AM','94','AM','Armenia' from sysibm.sysdummy1 union
        select 'AZ','95','AZ','Azerbaijan' from sysibm.sysdummy1 union
        select 'BD','96','BD','Bangladesh' from sysibm.sysdummy1 union
        select 'BT','97','BT','Bhutan' from sysibm.sysdummy1 union
        select 'BN','98','BN','Brunei' from sysibm.sysdummy1 union
        select 'MM','99','MM','Burma (Myanmar)' from sysibm.sysdummy1 union
        select 'KH','100','KH','Cambodia' from sysibm.sysdummy1 union
        select 'CN','101','CN','China' from sysibm.sysdummy1 union
        select 'TP','102','TP','East Timor' from sysibm.sysdummy1 union
        select 'GE','103','GE','Georgia' from sysibm.sysdummy1 union
        select 'IN','104','IN','India' from sysibm.sysdummy1 union
        select 'ID','105','ID','Indonesia' from sysibm.sysdummy1 union
        select 'IA','106','IA','Iran' from sysibm.sysdummy1 union
        select 'JP','107','JP','Japan' from sysibm.sysdummy1 union
        select 'KZ','108','KZ','Kazakhstan' from sysibm.sysdummy1 union
        select 'KP','109','KP','Korea (north)' from sysibm.sysdummy1 union
        select 'KR','110','KR','Korea (south)' from sysibm.sysdummy1 union
        select 'KG','111','KG','Kyrgyzstan' from sysibm.sysdummy1 union
        select 'LA','112','LA','Laos' from sysibm.sysdummy1 union
        select 'MY','113','MY','Malaysia' from sysibm.sysdummy1 union
        select 'MN','114','MN','Mongolia' from sysibm.sysdummy1 union
        select 'NP','115','NP','Nepal' from sysibm.sysdummy1 union
        select 'PK','116','PK','Pakistan' from sysibm.sysdummy1 union
        select 'PH','117','PH','Philippines' from sysibm.sysdummy1 union
        select 'RU','118','RU','Russia' from sysibm.sysdummy1 union
        select 'SG','119','SG','Singapore' from sysibm.sysdummy1 union
        select 'LK','120','LK','Sri Lanka' from sysibm.sysdummy1 union
        select 'TJ','121','TJ','Tajikistan' from sysibm.sysdummy1 union
        select 'TH','122','TH','Thailand' from sysibm.sysdummy1 union
        select 'TM','123','TM','Turkmenistan' from sysibm.sysdummy1 union
        select 'UZ','124','UZ','Uzbekistan' from sysibm.sysdummy1 union
        select 'VN','125','VN','Vietnam' from sysibm.sysdummy1 union
        select 'TW','126','TW','Taiwan' from sysibm.sysdummy1 union
        select 'HK','127','HK','Hong Kong' from sysibm.sysdummy1 union
        select 'MO','128','MO','Macau' from sysibm.sysdummy1 union
        select 'AL','129','AL','Albania' from sysibm.sysdummy1 union
        select 'AD','130','AD','Andorra' from sysibm.sysdummy1 union
        select 'AT','131','AT','Austria' from sysibm.sysdummy1 union
        select 'BY','132','BY','Belarus' from sysibm.sysdummy1 union
        select 'BE','133','BE','Belgium' from sysibm.sysdummy1 union
        select 'BH','134','BH','Bosnia and Herzegovina' from sysibm.sysdummy1 union
        select 'BG','135','BG','Bulgaria' from sysibm.sysdummy1 union
        select 'HY','136','HY','Croatia' from sysibm.sysdummy1 union
        select 'CZ','137','CZ','Czech Republic' from sysibm.sysdummy1 union
        select 'DK','138','DK','Denmark' from sysibm.sysdummy1 union
        select 'EE','139','EE','Estonia' from sysibm.sysdummy1 union
        select 'FI','140','FI','Finland' from sysibm.sysdummy1 union
        select 'FR','141','FR','France' from sysibm.sysdummy1 union
        select 'DE','142','DE','Germany' from sysibm.sysdummy1 union
        select 'GR','143','GR','Greece' from sysibm.sysdummy1 union
        select 'HU','144','HU','Hungary' from sysibm.sysdummy1 union
        select 'IS','145','IS','Iceland' from sysibm.sysdummy1 union
        select 'IR','146','IR','Ireland' from sysibm.sysdummy1 union
        select 'IT','147','IT','Italy' from sysibm.sysdummy1 union
        select 'LV','148','LV','Latvia' from sysibm.sysdummy1 union
        select 'LN','149','LN','Liechtenstein' from sysibm.sysdummy1 union
        select 'LT','150','LT','Lithuania' from sysibm.sysdummy1 union
        select 'LU','151','LU','Luxembourg' from sysibm.sysdummy1 union
        select 'MK','152','MK','Macedonia' from sysibm.sysdummy1 union
        select 'MT','153','MT','Malta' from sysibm.sysdummy1 union
        select 'MV','154','MV','Moldova' from sysibm.sysdummy1 union
        select 'MC','155','MC','Monaco' from sysibm.sysdummy1 union
        select 'MG','156','MG','Montenegro' from sysibm.sysdummy1 union
        select 'NL','157','NL','Netherlands' from sysibm.sysdummy1 union
        select 'NO','158','NO','Norway' from sysibm.sysdummy1 union
        select 'PL','159','PL','Poland' from sysibm.sysdummy1 union
        select 'PT','160','PT','Portugal' from sysibm.sysdummy1 union
        select 'RO','161','RO','Romania' from sysibm.sysdummy1 union
        select 'SM','162','SM','San Marino' from sysibm.sysdummy1 union
        select 'CS','163','CS','Serbia' from sysibm.sysdummy1 union
        select 'SK','164','SK','Slovakia' from sysibm.sysdummy1 union
        select 'SI','165','SI','Slovenia' from sysibm.sysdummy1 union
        select 'ES','166','ES','Spain' from sysibm.sysdummy1 union
        select 'SE','167','SE','Sweden' from sysibm.sysdummy1 union
        select 'CH','168','CH','Switzerland' from sysibm.sysdummy1 union
        select 'UA','169','UA','Ukraine' from sysibm.sysdummy1 union
        select 'UK','170','UK','United Kingdom' from sysibm.sysdummy1 union
        select 'VA','171','VA','Vatican City' from sysibm.sysdummy1 union
        select 'CY','172','CY','Cyprus' from sysibm.sysdummy1 union
        select 'TK','173','TK','Turkey' from sysibm.sysdummy1 union
        select 'AU','175','AU','Australia' from sysibm.sysdummy1 union
        select 'FJ','176','FJ','Fiji' from sysibm.sysdummy1 union
        select 'KI','177','KI','Kiribati' from sysibm.sysdummy1 union
        select 'MH','178','MH','Marshall Islands' from sysibm.sysdummy1 union
        select 'FM','179','FM','Micronesia' from sysibm.sysdummy1 union
        select 'NR','180','NR','Nauru' from sysibm.sysdummy1 union
        select 'NZ','181','NZ','New Zealand' from sysibm.sysdummy1 union
        select 'PW','182','PW','Palau' from sysibm.sysdummy1 union
        select 'PG','183','PG','Papua New Guinea' from sysibm.sysdummy1 union
        select 'WS','184','WS','Samoa' from sysibm.sysdummy1 union
        select 'SB','185','SB','Solomon Islands' from sysibm.sysdummy1 union
        select 'TO','186','TO','Tonga' from sysibm.sysdummy1 union
        select 'TV','187','TV','Tuvalu' from sysibm.sysdummy1 union
        select 'VU','188','VU','Vanuatu' from sysibm.sysdummy1 union
        select 'NC','189','NC','New Caledonia' from sysibm.sysdummy1 union
        select 'BA','190','BA','Bahrain' from sysibm.sysdummy1 union
        select 'IZ','191','IZ','Iraq' from sysibm.sysdummy1 union
        select 'IE','192','IE','Israel' from sysibm.sysdummy1 union
        select 'JO','193','JO','Jordan' from sysibm.sysdummy1 union
        select 'KU','194','KU','Kuwait' from sysibm.sysdummy1 union
        select 'LB','195','LB','Lebanon' from sysibm.sysdummy1 union
        select 'OM','196','OM','Oman' from sysibm.sysdummy1 union
        select 'QA','197','QA','Qatar' from sysibm.sysdummy1 union
        select 'SA','198','SA','Saudi Arabia' from sysibm.sysdummy1 union
        select 'SY','199','SY','Syria' from sysibm.sysdummy1 union
        select 'AE','200','AE','UnitedArabEmirates' from sysibm.sysdummy1 union
        select 'YM','201','YM','Yemen' from sysibm.sysdummy1 union
        select 'PR','202','PR','Puerto Rico' from sysibm.sysdummy1 union
        select 'KY','203','KY','Cayman Islands' from sysibm.sysdummy1 union
        select 'SS','204','SS','South Sudan' from sysibm.sysdummy1 union
        select 'KO','205','KO','Kosovo' from sysibm.sysdummy1;
COMMIT;
create table jrs_fusionmap_usa(
id	bigint 		GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
geoname_state varchar(2),
chartentityid varchar(2),
shortname varchar(2) ,
longname varchar(20), 
col1 		varchar(255),
col2 		varchar(255),
col3 		varchar(255),
col4 		varchar(255),
col5 		varchar(255),
constraint pk_jrs_fusionmap_usa primary key(id)
)
;
insert into jrs_fusionmap_usa(geoname_state,chartentityid,shortname,longname)
    select 'AL','AL','AL','Alabama' from sysibm.sysdummy1 union
    select 'AK','AK','AK','Alaska' from sysibm.sysdummy1 union
    select 'AZ','AZ','AZ','Arizona' from sysibm.sysdummy1 union
    select 'AR','AR','AR','Arkansas' from sysibm.sysdummy1 union
    select 'CA','CA','CA','California' from sysibm.sysdummy1 union
    select 'CO','CO','CO','Colorado' from sysibm.sysdummy1 union
    select 'CT','CT','CT','Connecticut' from sysibm.sysdummy1 union
    select 'DC','DC','DC','District of Columbia' from sysibm.sysdummy1 union
    select 'DE','DE','DE','Delaware' from sysibm.sysdummy1 union
    select 'FL','FL','FL','Florida' from sysibm.sysdummy1 union
    select 'GA','GA','GA','Georgia' from sysibm.sysdummy1 union
    select 'HI','HI','HI','Hawaii' from sysibm.sysdummy1 union
    select 'ID','ID','ID','Idaho' from sysibm.sysdummy1 union
    select 'IL','IL','IL','Illinois' from sysibm.sysdummy1 union
    select 'IN','IN','IN','Indiana' from sysibm.sysdummy1 union
    select 'IA','IA','IA','Iowa' from sysibm.sysdummy1 union
    select 'KS','KS','KS','Kansas' from sysibm.sysdummy1 union
    select 'KY','KY','KY','Kentucky' from sysibm.sysdummy1 union
    select 'LA','LA','LA','Louisiana' from sysibm.sysdummy1 union
    select 'ME','ME','ME','Maine' from sysibm.sysdummy1 union
    select 'MD','MD','MD','Maryland' from sysibm.sysdummy1 union
    select 'MA','MA','MA','Massachusetts' from sysibm.sysdummy1 union
    select 'MI','MI','MI','Michigan' from sysibm.sysdummy1 union
    select 'MN','MN','MN','Minnesota' from sysibm.sysdummy1 union
    select 'MS','MS','MS','Mississippi' from sysibm.sysdummy1 union
    select 'MO','MO','MO','Missouri' from sysibm.sysdummy1 union
    select 'MT','MT','MT','Montana' from sysibm.sysdummy1 union
    select 'NE','NE','NE','Nebraska' from sysibm.sysdummy1 union
    select 'NV','NV','NV','Nevada' from sysibm.sysdummy1 union
    select 'NH','NH','NH','New Hampshire' from sysibm.sysdummy1 union
    select 'NJ','NJ','NJ','New Jersey' from sysibm.sysdummy1 union
    select 'NM','NM','NM','New Mexico' from sysibm.sysdummy1 union
    select 'NY','NY','NY','New York' from sysibm.sysdummy1 union
    select 'NC','NC','NC','North Carolina' from sysibm.sysdummy1 union
    select 'ND','ND','ND','North Dakota' from sysibm.sysdummy1 union
    select 'OH','OH','OH','Ohio' from sysibm.sysdummy1 union
    select 'OK','OK','OK','Oklahoma' from sysibm.sysdummy1 union
    select 'OR','OR','OR','Oregon' from sysibm.sysdummy1 union
    select 'PA','PA','PA','Pennsylvania' from sysibm.sysdummy1 union
    select 'RI','RI','RI','Rhode Island' from sysibm.sysdummy1 union
    select 'SC','SC','SC','South Carolina' from sysibm.sysdummy1 union
    select 'SD','SD','SD','South Dakota' from sysibm.sysdummy1 union
    select 'TN','TN','TN','Tennessee' from sysibm.sysdummy1 union
    select 'TX','TX','TX','Texas' from sysibm.sysdummy1 union
    select 'UT','UT','UT','Utah' from sysibm.sysdummy1 union
    select 'VT','VT','VT','Vermont' from sysibm.sysdummy1 union
    select 'VA','VA','VA','Virginia' from sysibm.sysdummy1 union
    select 'WA','WA','WA','Washington' from sysibm.sysdummy1 union
    select 'WV','WV','WV','West Virginia' from sysibm.sysdummy1 union
    select 'WI','WI','WI','Wisconsin' from sysibm.sysdummy1 union
    select 'WY','WY','WY','Wyoming' from sysibm.sysdummy1;
COMMIT;
create table dim_date
(
id	bigint 		GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20, NO MINVALUE, NO MAXVALUE, NO CYCLE, NO ORDER),
  date_key int not null,
  dt date not null,
  year_number int not null,
  quarter_number int not null,
  quarter_name varchar(10) not null,
  month_number int not null,
  month_name varchar(10) not null,
  month_short_name varchar(3) not null, 
  week_of_year int not null,
  week_of_month int not null,
  month_full_weeks int not null,
  full_week_flag int not null,
  day_of_week_number int not null,
  day_of_week_short_name varchar(3) not null,
  day_of_week_name varchar(10) not null,
  day_number int not null,
 CONSTRAINT pk_dim_date primary key(id)
);
create table tmp_calendar (dt timestamp);
create view vw_dim_date 
as
select 
  date_key,
  dt,
  year_number,
  quarter_number,
  quarter_name,
  month_number,
  month_name,
  month_short_name,
  week_of_year,
  week_of_month,
  month_full_weeks,
  full_week_flag,
  day_of_week_number,
  day_of_week_short_name,
  day_of_week_name,
  day_number
from dim_date;
commit;
CREATE OR REPLACE VIEW vw_middleware_requests
(
  kaid,
  environmentid,
  awsid,
  ebid,
  deviceid,
  appid,
  appname,
  requestid,
  sessionid,
  channel,
  apptype,
  platform,
  idur,
  tdur,
  predur,
  exdur,
  prsdur,
  postdur,
  remoteip,
  ts,
  devicemodel,
  osversion,
  useragent,
  serviceid,
  formid,
  sessiontype,
  session_key,
  request_key,
  kuid,
  country,
  region,
  city,
  zip,
  lat,
  lon,
  dmacd,
  areacd,
  cnt,
  usagetype,
  sdktype,
  sdkversion,
  opstatus,
  httpcode,
  errmsg,
  errstack_var,
  errstack
)
AS 
 SELECT m.kaid, m.eid AS environmentid, m.awsid, m.ebid, m.did AS deviceid, m.aid AS appid, m.aname AS appname, m.rid AS requestid, m.sid AS sessionid, 
        CASE
            WHEN m.chnl = 'mobile' THEN 'Mobile'
            WHEN m.chnl = 'tablet' THEN 'Tablet'
            WHEN m.chnl = 'desktop' THEN 'Desktop'
            ELSE ''
        END AS channel, 
        CASE
            WHEN m.atype = 'hybrid' THEN 'Hybrid'
            WHEN m.atype = 'native' THEN 'Native'
            WHEN m.atype = 'mixedmode' THEN 'Mixed-Mode'
            WHEN m.atype = 'spa' THEN 'SPA'
            WHEN m.atype = 'mobileweb' THEN 'Mobile Web'
            ELSE ''
        END AS apptype, 
        CASE
            WHEN m.plat = 'ios' THEN 'iOS'
            WHEN m.plat = 'android' THEN 'Android'
            WHEN m.plat = 'blackberry' THEN 'Blackberry'
            WHEN m.plat = 'windows' THEN 'Windows'
            WHEN m.plat = 'j2me' THEN 'j2me'
            ELSE ''
        END AS platform, m.idur, m.tdur, m.predur, m.exdur, m.prsdur, m.postdur, m.rip AS remoteip, m.ts as ts, m.dm AS devicemodel, m.os AS osversion, m.ua AS useragent, m.svcid AS serviceid, m.fid AS formid, 
        CASE
            WHEN m.stype = 'b2c' THEN 'B2C'
            WHEN m.stype = 'b2e' THEN 'B2E'
            ELSE ''
        END AS sessiontype, m.session_key, m.request_key, m.kuid, m.country, m.region as region, m.city, m.zip, m.lat, m.lon, m.dmacd, m.areacd, 1 AS cnt, 
        CASE
            WHEN m.chnl = 'desktop' THEN 'D'
            WHEN m.atype = 'hybrid' OR m.atype = 'spa' OR m.atype = 'mobileweb' THEN 'W'
            ELSE 'N'
        END AS usagetype,
		sdktype,
		sdkversion,
		opstatus,
		httpcode,
		errmsg,
		errstack_var,
		errstack
   FROM middleware_requests m;
CREATE OR REPLACE VIEW vw_middleware_sessions
(
  kaid,
  environmentid,
  awsid,
  ebid,
  deviceid,
  appid,
  appname,
  sessionid,
  channel,
  apptype,
  platform,
  tdur,
  remoteip,
  ts,
  devicemodel,
  osversion,
  useragent,
  sessiontype,
  session_key,
  kuid,
  country,
  region,
  city,
  zip,
  lat,
  lon,
  dmacd,
  areacd,
  cnt,
  usagetype,
  sdkversion,
  opstatus,
  httpcode,
  errmsg,
  errstack_var,
  errstack
)
AS 
 SELECT m.kaid, m.eid AS environmentid, m.awsid, m.ebid, m.did AS deviceid, m.aid AS appid, m.aname AS appname, m.sid AS sessionid, 
        CASE
            WHEN m.chnl = 'mobile' THEN 'Mobile'
            WHEN m.chnl = 'tablet' THEN 'Tablet'
            WHEN m.chnl = 'desktop' THEN 'Desktop'
            ELSE ''
        END AS channel, 
        CASE
            WHEN m.atype = 'hybrid' THEN 'Hybrid'
            WHEN m.atype = 'native' THEN 'Native'
            WHEN m.atype = 'mixedmode' THEN 'Mixed-Mode'
            WHEN m.atype = 'spa' THEN 'SPA'
            WHEN m.atype = 'mobileweb' THEN 'Mobile Web'
            ELSE ''
        END AS apptype, 
        CASE
            WHEN m.plat = 'ios' THEN 'iOS'
            WHEN m.plat = 'android' THEN 'Android'
            WHEN m.plat = 'blackberry' THEN 'Blackberry'
            WHEN m.plat = 'windows' THEN 'Windows'
            WHEN m.plat = 'j2me' THEN 'j2me'
            ELSE ''
        END AS platform, m.tdur, m.rip AS remoteip, m.ts, m.dm AS devicemodel, m.os AS osversion, m.ua AS useragent, 
        CASE
            WHEN m.stype = 'b2c' THEN 'B2C'
            WHEN m.stype = 'b2e' THEN 'B2E'
            ELSE ''
        END AS sessiontype, m.session_key, m.kuid, m.country, m.region, m.city, m.zip, m.lat, m.lon, m.dmacd, m.areacd, 1 AS cnt, 
        CASE
            WHEN m.chnl = 'desktop' THEN 'D'
            WHEN m.atype = 'hybrid' OR m.atype = 'spa' OR m.atype = 'mobileweb' THEN 'W'
            ELSE 'N'
        END AS usagetype,
		sdkversion,
		opstatus,
		httpcode,
		errmsg,
		errstack_var,
		errstack
   FROM middleware_sessions m;
CREATE VIEW vw_application_events
(
  kaid,
  environmentid,
  awsid,
  ebid,
  deviceid,
  appid,
  appname,
  sessionid,
  channel,
  apptype,
  platform,
  remoteip,
  ts,
  devicemodel,
  osversion,
  useragent,
  sessiontype,
  session_key,
  request_key,
  kuid,
  country,
  region,
  city,
  zip,
  lat,
  lon,
  dmacd,
  areacd,
  cnt,
  usagetype,
  sdktype,
  skdversion,
  evttype,
  formid,
  widgetid,
  evtsubtype,
  flowtag,
  metadata
)
AS
 SELECT ae.kaid, ae.eid AS environmentid, ae.awsid, ae.ebid, ae.did AS deviceid, ae.aid AS appid, ae.aname AS appname, ae.sid AS sessionid,
   CASE
            WHEN ae.chnl = 'mobile' THEN 'Mobile'
            WHEN ae.chnl = 'tablet' THEN 'Tablet'
            WHEN ae.chnl = 'desktop' THEN 'Desktop'
            ELSE ''
        END AS channel,
        CASE
            WHEN ae.atype = 'hybrid' THEN 'Hybrid'
            WHEN ae.atype = 'native' THEN 'Native'
            WHEN ae.atype = 'mixedmode' THEN 'Mixed-Mode'
            WHEN ae.atype = 'spa' THEN 'SPA'
            WHEN ae.atype = 'mobileweb' THEN 'Mobile Web'
            ELSE ''
        END AS apptype,
        CASE
            WHEN ae.plat = 'ios' THEN 'iOS'
            WHEN ae.plat = 'android' THEN 'Android'
            WHEN ae.plat = 'blackberry' THEN 'Blackberry'
            WHEN ae.plat = 'windows' THEN 'Windows'
            WHEN ae.plat = 'j2me' THEN 'j2me'
            ELSE ''
        END AS platform, ae.rip AS remoteip, ae.ts, ae.dm AS devicemodel, ae.os AS osversion, ae.ua AS useragent,
        CASE
            WHEN ae.stype = 'b2c' THEN 'B2C'
            WHEN ae.stype = 'b2e' THEN 'B2E'
            ELSE ''
        END AS sessiontype, ae.session_key, ae.request_key, ae.kuid, ae.country, ae.region, ae.city, ae.zip, ae.lat, ae.lon, ae.dmacd, ae.areacd, 1 AS cnt,
        CASE
            WHEN ae.chnl = 'desktop' THEN 'D'
            WHEN ae.atype = 'hybrid' OR ae.atype = 'spa' OR ae.atype = 'mobileweb' THEN 'W'
            ELSE 'N'
        END AS usagetype, ae.sdktype, ae.sdkversion AS skdversion, ae.evttype, ae.formid, ae.widgetid, ae.evtsubtype, ae.flowtag, ae.metadata
   FROM application_events ae;
