-- Note: Replace schema names ("KONYADMIN"), database name (<konydb>), username (<username>) and password <password> with your actual values.
-- Follow the below command to run the script using DB2 command line client with ";" as line terminator/delimiter.
--     db2 -td';' -vf 03.konyadmin-db2-upg-6.0.3.2-6.5.0.sql
-- Connect to database using below command.
CONNECT TO <konydb> user <username> using <password>;
SET CURRENT SCHEMA "KONYADMIN";
insert  into build_version(build_version,build_date) values ('MIDDLEWARE-GA-6.5.0.0', CURRENT_TIMESTAMP);
CREATE TABLE "schema_version"
(
   "version_rank"    INTEGER          NOT NULL,
   "installed_rank"  INTEGER          NOT NULL,
   "version"         VARCHAR(50)      NOT NULL,
   "description"     VARCHAR(200)     NOT NULL,
   "type"            VARCHAR(20)      NOT NULL,
   "script"          VARCHAR(1000)    NOT NULL,
   "checksum"        INTEGER,
   "installed_by"    VARCHAR(100)     NOT NULL,
   "installed_on"    TIMESTAMP        DEFAULT CURRENT TIMESTAMP NOT NULL,
   "execution_time"  INTEGER          NOT NULL,
   "success"         SMALLINT         NOT NULL,
   CONSTRAINT schema_version_s CHECK ("success" in(0,1))
);
ALTER TABLE "schema_version"
   ADD CONSTRAINT "schema_version_pk"
   PRIMARY KEY ("version");
CREATE INDEX schema_version_ir_idx
   ON "schema_version" ("installed_rank" ASC);
CREATE INDEX schema_version_s_idx
   ON "schema_version" ("success" ASC);
CREATE INDEX schema_version_vr_idx
   ON "schema_version" ("version_rank" ASC);
INSERT INTO "schema_version" ("version_rank","installed_rank","version","description","type","script","checksum","installed_by","installed_on","execution_time","success")
VALUES
(
  1,
  1,
  '1',
  'konyadmin-db2-master',
  'SQL',
  'V1__konyadmin-db2-master.sql',
  -2132163001,
  'DBCLIENT',
  TIMESTAMP '2015-06-23 12:32:52.135078',
  1834,
  1
);
INSERT INTO "schema_version" ("version_rank","installed_rank","version","description","type","script","checksum","installed_by","installed_on","execution_time","success")
VALUES
(
  2,
  2,
  '2',
  'konyadmin-db2-6.5.0.0',
  'SQL',
  'V2__konyadmin-db2-6.5.0.0.sql',
  241365635,
  'DBCLIENT',
  TIMESTAMP '2015-06-23 12:32:52.220619',
  14,
  1
);
commit;