/**Note: Replace database names konyreports and konyadmin with your actual database names.**/
USE konyreports;

SET FOREIGN_KEY_CHECKS=0;

CREATE TABLE `dw_keys_request` (
   	`request_key`  	bigint(20)		NOT NULL AUTO_INCREMENT,
   	`rid`          	VARCHAR(255)   	NOT NULL,
   	`eid`          	VARCHAR(255)    NOT NULL,
   	`ts`    	DATETIME       NOT NULL,
   	`insert_date`  	TIMESTAMP    	DEFAULT CURRENT_TIMESTAMP NOT NULL,
   	`col1` varchar(255) DEFAULT NULL ,
	`col2` varchar(255) DEFAULT NULL,
	`col3` varchar(255) DEFAULT NULL,
	`col4` varchar(255) DEFAULT NULL,
	`col5` varchar(255) DEFAULT NULL,
	`created_by` 		VARCHAR(255) DEFAULT NULL,	
	`created_date` 		DATETIME DEFAULT NULL,	
	`updated_by` 		VARCHAR(255) DEFAULT NULL,
	`updated_date` 		DATETIME DEFAULT NULL,
   	PRIMARY KEY (`request_key`)
);

ALTER TABLE dw_keys_request
   ADD CONSTRAINT pk_dw_keys_request
   UNIQUE KEY (rid, eid, ts);
   

CREATE TABLE `dw_keys_session` (
   	`session_key`  bigint(20)		NOT NULL AUTO_INCREMENT,
   	`sid`          VARBINARY(100)	NOT NULL,
   	`hash_code`    VARBINARY(100)   NOT NULL,
   	`insert_date`  TIMESTAMP   		DEFAULT CURRENT_TIMESTAMP NOT NULL,
   	`col1` varchar(255) DEFAULT NULL ,
	`col2` varchar(255) DEFAULT NULL,
	`col3` varchar(255) DEFAULT NULL,
	`col4` varchar(255) DEFAULT NULL,
	`col5` varchar(255) DEFAULT NULL,
	`created_by` 		VARCHAR(255) DEFAULT NULL,	
	`created_date` 		DATETIME DEFAULT NULL,	
	`updated_by` 		VARCHAR(255) DEFAULT NULL,
	`updated_date` 		DATETIME DEFAULT NULL,
   	PRIMARY KEY (`session_key`)
);

ALTER TABLE dw_keys_session
   ADD CONSTRAINT pk_dw_keys_session
   UNIQUE KEY (sid, hash_code);

CREATE TABLE `geolocations_ip4` (
   	`startIpNum`  VARCHAR(15),
   	`endIpNum`    VARCHAR(15),
   	`startIpInt`  INT UNSIGNED   NOT NULL,
   	`endIpInt`    INT UNSIGNED   DEFAULT 0 NOT NULL,
   	`country`     VARCHAR(2),
   	`region`      VARCHAR(2),
   	`city`        VARCHAR(255),
   	`postalCode`  VARCHAR(6),
   	`latitude`    DECIMAL(8,5),
   	`longitude`   DECIMAL(8,5),
   	`dmaCode`     VARCHAR(3),
   	`areaCode`    VARCHAR(3),
   	`IPspatial`   POLYGON        NOT NULL,
   	`col1` varchar(255) DEFAULT NULL ,
	`col2` varchar(255) DEFAULT NULL,
	`col3` varchar(255) DEFAULT NULL,
	`col4` varchar(255) DEFAULT NULL,
	`col5` varchar(255) DEFAULT NULL,
	`created_by` 		VARCHAR(255) DEFAULT NULL,	
	`created_date` 		DATETIME DEFAULT NULL,	
	`updated_by` 		VARCHAR(255) DEFAULT NULL,
	`updated_date` 		DATETIME DEFAULT NULL
);

ALTER TABLE `geolocations_ip4`
   ADD CONSTRAINT pk_geolocations_ip4
   PRIMARY KEY (`startIpInt`, `endIpInt`);

CREATE INDEX `ux_geolocations_ip4_spatial`
   ON `geolocations_ip4` (IPspatial(32) ASC);
   
CREATE TABLE `crpt_owner` (
   	`id`       		bigint(20)		NOT NULL AUTO_INCREMENT,
   	`kaid`          varchar(255)    NOT NULL,
   	`eid`           VARCHAR(255)    NOT NULL,
   	`aid`           VARCHAR(255)	NOT NULL,
   	`dw_table_name` VARCHAR(255)  	NOT NULL,
  	`jrs_domain`    VARCHAR(255),
   	`col1` varchar(255) DEFAULT NULL ,
	`col2` varchar(255) DEFAULT NULL,
	`col3` varchar(255) DEFAULT NULL,
	`col4` varchar(255) DEFAULT NULL,
	`col5` varchar(255) DEFAULT NULL,
	`created_by` 		VARCHAR(255) DEFAULT NULL,	
	`created_date` 		DATETIME DEFAULT NULL,	
	`updated_by` 		VARCHAR(255) DEFAULT NULL,
	`updated_date` 		DATETIME DEFAULT NULL,
   	PRIMARY KEY (`id`)
);

ALTER TABLE `crpt_owner`
   ADD CONSTRAINT `uk_crpt_owner`
   UNIQUE KEY (`kaid`, `eid`, `aid`);

CREATE TABLE `crpt_metric` (
	`id`       		bigint(20)		NOT NULL AUTO_INCREMENT,
   	`owner_id`      bigint(20)      NOT NULL,
   	`name`          VARCHAR(255)   	NOT NULL,
   	`mtype`         VARCHAR(255)   	NOT NULL,
   	`dtype`         VARCHAR(255)   	NOT NULL,
   	`aggr_func`     VARCHAR(255),
   	`is_deleted`    bit(1) 				DEFAULT NULL,
   	`dw_column_name`	VARCHAR(255)   	NOT NULL,
   	`col1` varchar(255) DEFAULT NULL ,
	`col2` varchar(255) DEFAULT NULL,
	`col3` varchar(255) DEFAULT NULL,
	`col4` varchar(255) DEFAULT NULL,
	`col5` varchar(255) DEFAULT NULL,
	`created_by` 		VARCHAR(255) DEFAULT NULL,	
	`created_date` 		DATETIME DEFAULT NULL,	
	`updated_by` 		VARCHAR(255) DEFAULT NULL,
	`updated_date` 		DATETIME DEFAULT NULL,
   	PRIMARY KEY (`id`)
);
CREATE INDEX idx_crpt_metric_owner_id
   ON `crpt_metric` (`owner_id` ASC);

ALTER TABLE `crpt_metric`
  ADD CONSTRAINT `fk_crpt_metric_owner_id` FOREIGN KEY (`owner_id`)
  REFERENCES crpt_owner (`id`)
  ON UPDATE NO ACTION
  ON DELETE NO ACTION;
 
CREATE TABLE `crpt_master_info` (
   	`id`       		bigint(20)		NOT NULL AUTO_INCREMENT,
   	`datatype`      VARCHAR(20)		NOT NULL,
   	`col_prefix`    VARCHAR(20)	    NOT NULL,
   	`col_count`     SMALLINT		NOT NULL,
   	`col_metadata`	VARCHAR(255)	NOT NULL,
   	`jas_datatype`  VARCHAR(255)	DEFAULT NULL,
   	`col1` varchar(255) DEFAULT NULL ,
	`col2` varchar(255) DEFAULT NULL,
	`col3` varchar(255) DEFAULT NULL,
	`col4` varchar(255) DEFAULT NULL,
	`col5` varchar(255) DEFAULT NULL,
	`created_by` 		VARCHAR(255) DEFAULT NULL,	
	`created_date` 		DATETIME DEFAULT NULL,	
	`updated_by` 		VARCHAR(255) DEFAULT NULL,
	`updated_date` 		DATETIME DEFAULT NULL,
   	PRIMARY KEY (`id`)
);

CREATE TABLE `reports_settings` (
  `id`       		bigint(20)		NOT NULL AUTO_INCREMENT,
  `config_name` varchar(255) NOT NULL,
  `config_value` varchar(255) NOT NULL,
  `config_type` varchar(1000) NOT NULL,
  `selected` bit(1) DEFAULT NULL,
  `col1` varchar(255) DEFAULT NULL ,
  `col2` varchar(255) DEFAULT NULL,
  `col3` varchar(255) DEFAULT NULL,
  `col4` varchar(255) DEFAULT NULL,
  `col5` varchar(255) DEFAULT NULL,
  `created_by` 		VARCHAR(255) DEFAULT NULL,	
  `created_date` 		DATETIME DEFAULT NULL,	
  `updated_by` 		VARCHAR(255) DEFAULT NULL,
  `updated_date` 		DATETIME DEFAULT NULL,
  PRIMARY KEY (`id`)
);

ALTER TABLE `reports_settings`
   ADD CONSTRAINT `uk_reports_settings_name`
   UNIQUE KEY (`config_name`);
   
ALTER TABLE `service_mapping` MODIFY COLUMN `menuname` VARCHAR(255) NULL;
ALTER TABLE `service_mapping` MODIFY  COLUMN `eventname` VARCHAR(255) NULL;

ALTER TABLE `form_mapping` MODIFY COLUMN `menuname` VARCHAR(255) NULL;
ALTER TABLE `form_mapping` MODIFY COLUMN `eventname` VARCHAR(255) NULL;

CREATE TABLE `build_version` (
  `build_version` varchar(255) DEFAULT NULL,
  `build_date` datetime DEFAULT NULL
);

insert  into `build_version`(`build_version`,`build_date`) values ('MIDDLEWARE-GA-6.0.3.1', NOW());

/**copy data from konyadmin into konyreports.**/

insert into	`dw_keys_request` select * from konyadmin.`dw_keys_request`;
insert into	`dw_keys_session` select * from konyadmin.`dw_keys_session`;
insert into	`geolocations_ip4` select * from konyadmin.`geolocations_ip4`;
insert into	`crpt_owner` select * from konyadmin.`crpt_owner`;
insert into	`crpt_metric` select * from konyadmin.`crpt_metric`;
insert into	`crpt_master_info` select * from konyadmin.`crpt_master_info`;
insert into	`reports_settings` select * from konyadmin.`reports_settings`;

commit;

SET FOREIGN_KEY_CHECKS=1;
