/** Note: Replace database names konyreports and konyadmin with your actual database names.**/
USE konyadmin;
insert  into build_version(build_version, build_date) values ('MIDDLEWARE-GA-6.5.0.0', NOW());
CREATE TABLE schema_version
(
   version_rank    INT             NOT NULL,
   installed_rank  INT             NOT NULL,
   version         VARCHAR(50)     NOT NULL,
   description     VARCHAR(200)    NOT NULL,
   type            VARCHAR(20)     NOT NULL,
   script          VARCHAR(1000)   NOT NULL,
   checksum        INT,
   installed_by    VARCHAR(100)    NOT NULL,
   installed_on    TIMESTAMP       DEFAULT CURRENT_TIMESTAMP NOT NULL,
   execution_time  INT             NOT NULL,
   success         BIT             NOT NULL,
   PRIMARY KEY (version)
);

CREATE INDEX schema_version_ir_idx
   ON schema_version (installed_rank ASC);

CREATE INDEX schema_version_s_idx
   ON schema_version (success ASC);

CREATE INDEX schema_version_vr_idx
   ON schema_version (version_rank ASC);
   

INSERT INTO schema_version
(
  version_rank,
  installed_rank,
  version,
  description,
  TYPE,
  script,
  checksum,
  installed_by,
  installed_on,
  execution_time,
  success
)
VALUES
(
  1,
  1,
  '1',
  'konyadmin-mysql-master',
  'SQL',
  'V1__konyadmin-mysql-master.sql',
  1792919407,
  'root',
  TIMESTAMP '2015-06-23 12:33:34.000',
  20455,
  TRUE
);

INSERT INTO schema_version
(
  version_rank,
  installed_rank,
  version,
  description,
  TYPE,
  script,
  checksum,
  installed_by,
  installed_on,
  execution_time,
  success
)
VALUES
(
  2,
  2,
  '2',
  'konyadmin-mysql-6.5.0.0',
  'SQL',
  'V2__konyadmin-mysql-6.5.0.0.sql',
  1158773272,
  'root',
  TIMESTAMP '2015-06-23 12:33:35.000',
  1094,
  TRUE
);
commit;