-- login to konyreports schema

-- DELIMITER ;
-- reports_settings;
CREATE TABLE reports_settings (
  id       		number(20)		NOT NULL ,
  config_name varchar2(255) NOT NULL,
  config_value varchar2(255) NOT NULL,
  config_type varchar2(1000) NOT NULL,
  selected char(1) DEFAULT NULL,
  col1 varchar2(255) DEFAULT NULL ,
  col2 varchar2(255) DEFAULT NULL,
  col3 varchar2(255) DEFAULT NULL,
  col4 varchar2(255) DEFAULT NULL,
  col5 varchar2(255) DEFAULT NULL,
  created_by 		varchar2(255) DEFAULT NULL,	
  created_date 		DATE DEFAULT NULL,	
  updated_by 		varchar2(255) DEFAULT NULL,
  updated_date 		DATE DEFAULT NULL,
  constraint pk_reports_settings PRIMARY KEY(id) USING INDEX tablespace USERS,
  constraint uk_reports_settings_name unique(config_name) using INDEX tablespace USERS
) tablespace USERS;

CREATE SEQUENCE SEQ_reports_settings
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;

-- DELIMITER /
  
CREATE OR REPLACE TRIGGER TRG_reports_settings BEFORE INSERT ON reports_settings
FOR EACH ROW
DECLARE 
max_id number;
cur_seq number;
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
    SELECT  SEQ_reports_settings.NEXTVAL INTO :new.id FROM DUAL;
    else 
      SELECT greatest(NVL(max(id),0), :new.id) into max_id from reports_settings;
      select SEQ_reports_settings.nextval into cur_seq from dual; while cur_seq < max_id
      LOOP
           
           SELECT SEQ_reports_settings.nextval INTO cur_seq FROM dual;
      END LOOP;
    END IF;

END;
/

-- dw_keys_request;
CREATE TABLE dw_keys_request (
   	request_key  	number(20)		NOT NULL ,
   	rid          	varchar2(255)   	NOT NULL,
   	eid          	varchar2(255)    NOT NULL,
   	ts    			TIMESTAMP       NOT NULL,
   	insert_date  	TIMESTAMP    	DEFAULT CURRENT_TIMESTAMP NOT NULL,
   	col1 varchar2(255) DEFAULT NULL ,
	col2 varchar2(255) DEFAULT NULL,
	col3 varchar2(255) DEFAULT NULL,
	col4 varchar2(255) DEFAULT NULL,
	col5 varchar2(255) DEFAULT NULL,
	created_by 		varchar2(255) DEFAULT NULL,	
	created_date 		DATE DEFAULT NULL,	
	updated_by 		varchar2(255) DEFAULT NULL,
	updated_date 		DATE DEFAULT NULL,
  constraint pk_dw_keys_request PRIMARY KEY(request_key) USING INDEX tablespace USERS,
  constraint uk_dw_keys_request unique(rid, eid, ts) using INDEX tablespace USERS
) tablespace USERS;


CREATE SEQUENCE SEQ_dw_keys_request
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;
  
  
-- DELIMITER /
  
CREATE OR REPLACE TRIGGER TRG_dw_keys_request BEFORE INSERT ON dw_keys_request
FOR EACH ROW
DECLARE 
max_id number;
cur_seq number;
BEGIN
  IF INSERTING AND :new.request_key IS NULL THEN
    SELECT  SEQ_dw_keys_request.NEXTVAL INTO :new.request_key FROM DUAL;
    else 
      SELECT greatest(NVL(max(request_key),0), :new.request_key) into max_id from dw_keys_request;
      select SEQ_dw_keys_request.nextval into cur_seq from dual; while cur_seq < max_id
      LOOP
           
           SELECT SEQ_dw_keys_request.nextval INTO cur_seq FROM dual;
      END LOOP;
    END IF;

END;
/

-- DELIMITER ;

-- dw_keys_session;
CREATE TABLE dw_keys_session (
       session_key  number(20)        NOT NULL ,
       sid          RAW(255)       NOT NULL,
       hash_code    RAW(255)       NOT NULL,
       insert_date  TIMESTAMP           DEFAULT CURRENT_TIMESTAMP NOT NULL,
       col1 varchar2(255) DEFAULT NULL ,
    col2 varchar2(255) DEFAULT NULL,
    col3 varchar2(255) DEFAULT NULL,
    col4 varchar2(255) DEFAULT NULL,
    col5 varchar2(255) DEFAULT NULL,
    created_by         varchar2(255) DEFAULT NULL,    
    created_date         DATE DEFAULT NULL,    
    updated_by         varchar2(255) DEFAULT NULL,
    updated_date         DATE DEFAULT NULL,
  constraint pk_dw_keys_session PRIMARY KEY(session_key) USING INDEX tablespace USERS,
  constraint uk_dw_keys_session unique(sid, hash_code) using INDEX tablespace USERS
) tablespace USERS;


   
CREATE SEQUENCE SEQ_dw_keys_session
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;
  
-- DELIMITER /
  
CREATE OR REPLACE TRIGGER TRG_dw_keys_session BEFORE INSERT ON dw_keys_session
FOR EACH ROW
DECLARE 
max_id number;
cur_seq number;
BEGIN
  IF INSERTING AND :new.session_key IS NULL THEN
    SELECT  SEQ_dw_keys_session.NEXTVAL INTO :new.session_key FROM DUAL;
    else 
      SELECT greatest(NVL(max(session_key),0), :new.session_key) into max_id from dw_keys_session;
      select SEQ_dw_keys_session.nextval into cur_seq from dual; while cur_seq < max_id
      LOOP
           
           SELECT SEQ_dw_keys_session.nextval INTO cur_seq FROM dual;
      END LOOP;
    END IF;

END;
/


-- DELIMITER ;
   
-- geolocations_ip4;
CREATE TABLE geolocations_ip4 (
   	startIpNum  varchar2(15),
   	endIpNum    varchar2(15),
   	startIpInt  INTEGER   NOT NULL,
   	endIpInt    INTEGER   DEFAULT 0 NOT NULL,
   	country     varchar2(2),
   	region      varchar2(2),
   	city        varchar2(255),
   	postalCode  varchar2(6),
   	latitude    number(8,5),
   	longitude   number(8,5),
   	dmaCode     varchar2(3),
   	areaCode    varchar2(3),
   	IPspatial   SDO_GEOMETRY        NOT NULL,
   	col1 varchar2(255) DEFAULT NULL ,
	col2 varchar2(255) DEFAULT NULL,
	col3 varchar2(255) DEFAULT NULL,
	col4 varchar2(255) DEFAULT NULL,
	col5 varchar2(255) DEFAULT NULL,
	created_by 		varchar2(255) DEFAULT NULL,	
	created_date 		DATE DEFAULT NULL,	
	updated_by 		varchar2(255) DEFAULT NULL,
	updated_date 		DATE DEFAULT NULL,
	constraint pk_geolocations_ip4 PRIMARY KEY(startIpInt, endIpInt) USING INDEX tablespace USERS
) tablespace USERS;

-- crpt_owner;
CREATE TABLE crpt_owner (
   	id       		number(20)		NOT NULL ,
   	kaid          varchar2(255)    NOT NULL,
   	eid           varchar2(255)    NOT NULL,
   	aid           varchar2(255)	NOT NULL,
   	dw_table_name varchar2(255)  	NOT NULL,
  	jrs_domain    varchar2(255),
   	col1 varchar2(255) DEFAULT NULL ,
	col2 varchar2(255) DEFAULT NULL,
	col3 varchar2(255) DEFAULT NULL,
	col4 varchar2(255) DEFAULT NULL,
	col5 varchar2(255) DEFAULT NULL,
	created_by 		varchar2(255) DEFAULT NULL,	
	created_date 		DATE DEFAULT NULL,	
	updated_by 		varchar2(255) DEFAULT NULL,
	updated_date 		DATE DEFAULT NULL,
constraint pk_crpt_owner PRIMARY KEY(id) USING INDEX tablespace USERS,
	constraint uk_crpt_owner unique(kaid, eid, aid) using INDEX tablespace USERS
    ) tablespace USERS;


  CREATE SEQUENCE SEQ_crpt_owner
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;
  
  
-- DELIMITER /
  
CREATE OR REPLACE TRIGGER TRG_crpt_owner BEFORE INSERT ON crpt_owner
FOR EACH ROW
DECLARE 
max_id number;
cur_seq number;
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
    SELECT  SEQ_crpt_owner.NEXTVAL INTO :new.id FROM DUAL;
    else 
      SELECT greatest(NVL(max(id),0), :new.id) into max_id from crpt_owner;
      select SEQ_crpt_owner.nextval into cur_seq from dual; while cur_seq < max_id
      LOOP
           
           SELECT SEQ_crpt_owner.nextval INTO cur_seq FROM dual;
      END LOOP;
    END IF;

END;
/

-- DELIMITER ;

-- crpt_metric;
CREATE TABLE crpt_metric (
    id               number(20)        NOT NULL ,
       owner_id      number(20)      NOT NULL,
       name          varchar2(255)       NOT NULL,
       mtype         varchar2(255)       NOT NULL,
       dtype         varchar2(255)       NOT NULL,
       aggr_func     varchar2(255),
       is_deleted    char(1)                 DEFAULT NULL,
       dw_column_name    varchar2(255)       NOT NULL,
       col1 varchar2(255) DEFAULT NULL ,
    col2 varchar2(255) DEFAULT NULL,
    col3 varchar2(255) DEFAULT NULL,
    col4 varchar2(255) DEFAULT NULL,
    col5 varchar2(255) DEFAULT NULL,
    created_by         varchar2(255) DEFAULT NULL,    
    created_date         DATE DEFAULT NULL,    
    updated_by         varchar2(255) DEFAULT NULL,
    updated_date         DATE DEFAULT NULL,
constraint pk_crpt_metric PRIMARY KEY(id) USING INDEX tablespace USERS,
CONSTRAINT fk_crpt_metric_owner_id FOREIGN KEY (owner_id) REFERENCES crpt_owner (id)	 
) tablespace USERS;

CREATE SEQUENCE SEQ_crpt_metric
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;
  
  
-- DELIMITER /
  
CREATE OR REPLACE TRIGGER TRG_crpt_metric BEFORE INSERT ON crpt_metric
FOR EACH ROW
DECLARE 
max_id number;
cur_seq number;
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
    SELECT  SEQ_crpt_metric.NEXTVAL INTO :new.id FROM DUAL;
    else 
      SELECT greatest(NVL(max(id),0), :new.id) into max_id from crpt_metric;
      select SEQ_crpt_metric.nextval into cur_seq from dual; while cur_seq < max_id
      LOOP
           
           SELECT SEQ_crpt_metric.nextval INTO cur_seq FROM dual;
      END LOOP;
    END IF;

END;
/

-- DELIMITER ;

CREATE INDEX idx_crpt_metric_owner_id
   ON crpt_metric (owner_id ASC);
 
 -- crpt_master_info;
CREATE TABLE crpt_master_info (
   	id       		number(20)		NOT NULL ,
   	datatype      varchar2(20)		NOT NULL,
   	col_prefix    varchar2(20)	    NOT NULL,
   	col_count     SMALLINT		NOT NULL,
   	col_metadata	varchar2(255)	NOT NULL,
   	jas_datatype  varchar2(255)	DEFAULT NULL,
   	col1 varchar2(255) DEFAULT NULL ,
	col2 varchar2(255) DEFAULT NULL,
	col3 varchar2(255) DEFAULT NULL,
	col4 varchar2(255) DEFAULT NULL,
	col5 varchar2(255) DEFAULT NULL,
	created_by 		varchar2(255) DEFAULT NULL,	
	created_date 		DATE DEFAULT NULL,	
	updated_by 		varchar2(255) DEFAULT NULL,
	updated_date 		DATE DEFAULT NULL,
constraint pk_crpt_master_info PRIMARY KEY(id) USING INDEX tablespace USERS
) tablespace USERS;

CREATE SEQUENCE SEQ_crpt_master_info
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;

-- DELIMITER /  

CREATE OR REPLACE TRIGGER TRG_crpt_master_info BEFORE INSERT ON crpt_master_info
FOR EACH ROW
DECLARE 
max_id number;
cur_seq number;
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
    SELECT  SEQ_crpt_master_info.NEXTVAL INTO :new.id FROM DUAL;
    else 
      SELECT greatest(NVL(max(id),0), :new.id) into max_id from crpt_master_info;
      select SEQ_crpt_master_info.nextval into cur_seq from dual; while cur_seq < max_id
      LOOP
           
           SELECT SEQ_crpt_master_info.nextval INTO cur_seq FROM dual;
      END LOOP;
    END IF;

END;
/

-- DELIMITER ;

CREATE TABLE build_version (
   	build_version varchar2(255) DEFAULT NULL ,
	build_date 	DATE DEFAULT NULL	
) tablespace USERS;

INSERT INTO build_version(build_version, build_date) values ('MIDDLEWARE-GA-6.0.3.1', to_date(sysdate,'yyyy-mm-dd hh24:mi:ss'));
commit;

ALTER TABLE service_mapping MODIFY(menuname  NULL);
ALTER TABLE service_mapping MODIFY(eventname  NULL);

ALTER TABLE form_mapping MODIFY(menuname NULL);
ALTER TABLE form_mapping MODIFY(eventname NULL);
commit;

alter trigger TRG_reports_settings disable;
alter trigger TRG_dw_keys_request  disable;
alter trigger TRG_dw_keys_session  disable;
alter trigger TRG_crpt_owner       disable;
alter trigger TRG_crpt_metric      disable;
alter trigger TRG_crpt_master_info disable;

insert into reports_settings select * from konyadmin.reports_settings;
insert into dw_keys_request  select * from konyadmin.dw_keys_request ;
insert into dw_keys_session  select * from konyadmin.dw_keys_session ;
insert into geolocations_ip4 select * from konyadmin.geolocations_ip4;
insert into crpt_owner       select * from konyadmin.crpt_owner      ;
insert into crpt_metric      select * from konyadmin.crpt_metric     ;
insert into crpt_master_info select * from konyadmin.crpt_master_info;

alter trigger TRG_reports_settings enable;
alter trigger TRG_dw_keys_request  enable;
alter trigger TRG_dw_keys_session  enable;
alter trigger TRG_crpt_owner       enable;
alter trigger TRG_crpt_metric      enable;
alter trigger TRG_crpt_master_info enable;

-- DELIMITER /

DECLARE max_id number; cur_seq number; BEGIN SELECT NVL(max(id),0)			 into max_id from reports_settings;			select '1' into cur_seq from dual; while cur_seq < max_id LOOP SELECT SEQ_reports_settings.nextval INTO cur_seq FROM dual; END LOOP; END;
/
DECLARE max_id number; cur_seq number; BEGIN SELECT NVL(max(session_key),0)	 into max_id from dw_keys_session;			select '1' into cur_seq from dual; while cur_seq < max_id LOOP SELECT SEQ_dw_keys_session.nextval INTO cur_seq FROM dual; END LOOP; END;
/
DECLARE max_id number; cur_seq number; BEGIN SELECT NVL(max(request_key),0)	 into max_id from dw_keys_request;			select '1' into cur_seq from dual; while cur_seq < max_id LOOP SELECT SEQ_dw_keys_request.nextval INTO cur_seq FROM dual; END LOOP; END;
/
DECLARE max_id number; cur_seq number; BEGIN SELECT NVL(max(id),0)			 into max_id from custom_metrics_master; 	select '1' into cur_seq from dual; while cur_seq < max_id LOOP SELECT SEQ_custom_metrics_master.nextval INTO cur_seq FROM dual; END LOOP; END;
/
DECLARE max_id number; cur_seq number; BEGIN SELECT NVL(max(id),0)			 into max_id from crpt_owner;				select '1' into cur_seq from dual; while cur_seq < max_id LOOP SELECT SEQ_crpt_owner.nextval INTO cur_seq FROM dual; END LOOP; END;
/
DECLARE max_id number; cur_seq number; BEGIN SELECT NVL(max(id),0)			 into max_id from crpt_metric;				select '1' into cur_seq from dual; while cur_seq < max_id LOOP SELECT SEQ_crpt_metric.nextval INTO cur_seq FROM dual; END LOOP; END;
/
DECLARE max_id number; cur_seq number; BEGIN SELECT NVL(max(id),0)			 into max_id from crpt_master_info;			select '1' into cur_seq from dual; while cur_seq < max_id LOOP SELECT SEQ_crpt_master_info.nextval INTO cur_seq FROM dual; END LOOP; END;
/

-- DELIMITER ;
commit;