-- Grant create view permission to konyreports user
-- Ex: grant create view to konyreports;
-- login to konyreports user

-- DELIMITER ;
ALTER SESSION SET NLS_LENGTH_SEMANTICS = 'CHAR';
SET ESCAPE ON;
INSERT INTO build_version(build_version, build_date) values ('MIDDLEWARE-GA-6.5.0.0', to_date(sysdate,'yyyy-mm-dd hh24:mi:ss'));
CREATE TABLE "schema_version"
(
   "version_rank"    NUMBER                NOT NULL,
   "installed_rank"  NUMBER                NOT NULL,
   "version"         VARCHAR2(50 Byte)     NOT NULL,
   "description"     VARCHAR2(200 Byte)    NOT NULL,
   "type"            VARCHAR2(20 Byte)     NOT NULL,
   "script"          VARCHAR2(1000 Byte)   NOT NULL,
   "checksum"        NUMBER,
   "installed_by"    VARCHAR2(100 Byte)    NOT NULL,
   "installed_on"    TIMESTAMP(6)          DEFAULT CURRENT_TIMESTAMP NOT NULL,
   "execution_time"  NUMBER                NOT NULL,
   "success"         NUMBER(1)             NOT NULL
)
TABLESPACE USERS;

ALTER TABLE "schema_version"
   ADD CONSTRAINT "schema_version_pk"
   PRIMARY KEY ("version") 
   USING INDEX TABLESPACE USERS;

CREATE INDEX "schema_version_ir_idx"
   ON "schema_version" ("installed_rank" ASC)
   TABLESPACE USERS;

CREATE INDEX "schema_version_s_idx"
   ON "schema_version" ("success" ASC)
   TABLESPACE USERS;

CREATE INDEX "schema_version_vr_idx"
   ON "schema_version" ("version_rank" ASC)
   TABLESPACE USERS;


INSERT INTO "schema_version"
(
  "version_rank",
  "installed_rank",
  "version",
  "description",
  "type",
  "script",
  "checksum",
  "installed_by",
  "installed_on",
  "execution_time",
  "success"
)
VALUES
(
  1,
  1,
  '1',
  'oracle reports db',
  'SQL',
  'V1__oracle_reports_db.sql',
  1041868182,
  'KONYREPORTS60320',
  TO_TIMESTAMP('2015-06-15 14:23:30.945','YYYY-MM-DD HH24:MI:SS.FF'),
  814,
  1
);

INSERT INTO "schema_version"
(
  "version_rank",
  "installed_rank",
  "version",
  "description",
  "type",
  "script",
  "checksum",
  "installed_by",
  "installed_on",
  "execution_time",
  "success"
)
VALUES
(
  2,
  2,
  '2',
  'oracle reports db',
  'SQL',
  'V2__oracle_reports_db.sql',
  -830084587,
  'KONYREPORTS60320',
  TO_TIMESTAMP('2015-06-15 14:23:31.664','YYYY-MM-DD HH24:MI:SS.FF'),
  708,
  1
);

INSERT INTO "schema_version"
(
  "version_rank",
  "installed_rank",
  "version",
  "description",
  "type",
  "script",
  "checksum",
  "installed_by",
  "installed_on",
  "execution_time",
  "success"
)
VALUES
(
  3,
  3,
  '3',
  'oracle reports db',
  'SQL',
  'V3__oracle_reports_db.sql',
  1094322443,
  'KONYREPORTS60320',
  TO_TIMESTAMP('2015-06-15 14:23:33.212','YYYY-MM-DD HH24:MI:SS.FF'),
  1532,
  1
);

   
   
create table application_events
(
    id              number(20) 		NOT NULL,
    bid   			varchar2(255)   NOT NULL,
    mid   			varchar2(255),
    kaid 			varchar2(255)   NOT NULL,
    eid   			varchar2(255)   NOT NULL,
	aid 			varchar2(255)   NOT NULL,
    ts 				TIMESTAMP     	NOT NULL, 
    evttype 		varchar2(100)  	NOT NULL,
    formid   		varchar2(255),
    widgetid   		varchar2(255),
    sid				varchar2(255)   NOT NULL,
    evtsubtype   	varchar2(255),
    flowtag   		varchar2(255),
    request_key 	number(20),
    session_key 	number(20) 		NOT NULL,
	metadata_var  	varchar2(4000),
	metadata 		CLOB,
	col1 			varchar2(255),
	col2 			varchar2(255),
	col3 			varchar2(255),
	col4 			varchar2(255),
	col5 			varchar2(255),
	constraint pk_application_events primary key(id),
	CONSTRAINT fk_application_events_skey FOREIGN KEY (session_key) REFERENCES middleware_sessions (session_key),
	CONSTRAINT fk_application_events_req_key FOREIGN KEY (request_key) REFERENCES middleware_requests (request_key)
	) 
;

CREATE INDEX fk_application_events_skey ON application_events(session_key);
CREATE INDEX fk_application_events_req_key ON application_events(request_key);


CREATE SEQUENCE SEQ_application_events
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;


create table application_service_detail
(
    id               number(20) 	NOT NULL ,
    bid   			varchar2(255)   not null,
    mid   			varchar2(255),
    kaid    		varchar2(255)   not null,
    eid     		varchar2(255)   not null,
    aid     		varchar2(255)   not null,
    ts 				TIMESTAMP     not null,
    evttype 		varchar2(100)  not null,
	aname varchar2(255),
	atype varchar2(255) not null,
	plat varchar2(255) not null,
	chnl varchar2(255) not null,
    formid   		varchar2(255), 
    widgetid   		varchar2(255),
    sid   		    varchar2(255)  not null,
    evtsubtype   	varchar2(255),
    flowtag   		varchar2(255),
    request_key 	NUMBER(20),
    session_key 	NUMBER(20) NOT NULL,
    opstatus        varchar2(50) NOT NULL,
    httpcode        NUMBER(10) NOT NULL,
    resptime        NUMBER(10) NOT NULL,
	col1 		varchar2(255),
	col2 		varchar2(255),
	col3 		varchar2(255),
	col4 		varchar2(255),
	col5 		varchar2(255),
	constraint pk_application_service_dtl primary key(id) ,
	CONSTRAINT fk_application_service_dtl_sky FOREIGN KEY (session_key) REFERENCES middleware_sessions (session_key),
	CONSTRAINT fk_application_service_dtl_rky FOREIGN KEY (request_key) REFERENCES middleware_requests (request_key)
	) 
;

CREATE INDEX fk_application_service_dtl_sky ON application_service_detail(session_key);
CREATE INDEX fk_application_service_dtl_rky ON application_service_detail(request_key);


CREATE SEQUENCE SEQ_application_service_detail
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;



create table application_error_detail
(
    id          number(20) 	NOT NULL,
    bid   			varchar2(255)   not null,
    mid   			varchar2(255),
    kaid    		varchar2(255)   not null,
    eid     		varchar2(255)   not null,
    aid     		varchar2(255)   not null,
    ts 				TIMESTAMP     not null,
    evttype 		varchar2(100)  not null,
	aname varchar2(255),
	atype varchar2(255) not null,
	plat varchar2(255) not null,
	chnl varchar2(255) not null,
    formid   		varchar2(255),
    widgetid   		varchar2(255),
    sid   		    varchar2(255)  not null,
    evtsubtype   	varchar2(255),
    flowtag   		varchar2(255),
    request_key 	number(20),
    session_key 	number(20) NOT NULL,
    errcode         varchar2(50),
    errmsg          varchar2(255),
    errfile         varchar2 (255),
    errmethod       varchar2(255),
    errline         number(10),
	errstacktrace_var varchar2(4000),
    errstacktrace   clob,
    errtype         varchar2(255),
    iserror         number(3),
	errcustommsg_var varchar2(4000),
	errcustommsg clob,
	errcrashreport_var varchar2(4000),
	errcrashreport clob,
	col1 		varchar2(255),
	col2 		varchar2(255),
	col3 		varchar2(255),
	col4 		varchar2(255),
	col5 		varchar2(255),
	constraint pk_application_error_dtl primary key(id) ,
	CONSTRAINT fk_application_error_dtl_sky FOREIGN KEY (session_key) REFERENCES middleware_sessions (session_key),
	CONSTRAINT fk_application_error_dtl_rky FOREIGN KEY (request_key) REFERENCES middleware_requests (request_key)

	) ;

	CREATE INDEX fk_application_error_dtl_sky ON application_error_detail(session_key);
	CREATE INDEX fk_application_error_dtl_rky ON application_error_detail(request_key);

	
	
CREATE SEQUENCE SEQ_application_error_detail
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;


	

-- ALTER SCRIPTS FOR MIDDLEWARE REQUESTS

ALTER TABLE middleware_requests ADD sdktype varchar2(50);
ALTER TABLE middleware_requests ADD sdkversion varchar2(50) ;
ALTER TABLE middleware_requests ADD opstatus number(10);
ALTER TABLE middleware_requests ADD httpcode number(10);
ALTER TABLE middleware_requests ADD errmsg varchar2(4000) ;
ALTER TABLE middleware_requests ADD errstack_var varchar2(4000) ;
ALTER TABLE middleware_requests ADD errstack CLOB ;

-- ALTER SCRIPTS FOR MIDDLEWARE SESSIONS

ALTER TABLE middleware_sessions ADD sdktype varchar2(50);
ALTER TABLE middleware_sessions ADD sdkversion varchar2(50) ;
ALTER TABLE middleware_sessions ADD opstatus number(10);
ALTER TABLE middleware_sessions ADD httpcode number(10);
ALTER TABLE middleware_sessions ADD errmsg varchar2(4000);
ALTER TABLE middleware_sessions ADD errstack_var varchar2(4000) ;
ALTER TABLE middleware_sessions ADD errstack CLOB ;


create table jrs_fusionmap_world(
id  number(20) 	NOT NULL ,
geoname_country varchar2(2),
chartentityid varchar2(3),
shortname varchar2(2),
longname varchar2(50),
col1 		varchar2(255),
col2 		varchar2(255),
col3 		varchar2(255),
col4 		varchar2(255),
col5 		varchar2(255),
constraint pk_jrs_fusionmap_world primary key(id)
	) 
;

CREATE SEQUENCE SEQ_jrs_fusionmap_world
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;

-- DELIMITER /
  
CREATE OR REPLACE TRIGGER TRG_jrs_fusionmap_world BEFORE INSERT ON jrs_fusionmap_world
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      SELECT SEQ_jrs_fusionmap_world.nextval into :new.id  from dual; 
   END IF;
END;
/
  
insert into jrs_fusionmap_world(geoname_country,chartentityid,shortname,longname)
        select  'AG','1','AG','Antigua and Barbuda' from dual  union
        select  'BS','2','BS','Bahamas' from dual  union
        select  'BB','3','BB','Barbados' from dual  union
        select  'BZ','4','BZ','Belize' from dual union
        select  'CA','5','CA','Canada' from dual union
        select  'CR','6','CR','Costa Rica' from dual union
        select  'CU','7','CU','Cuba' from dual union
        select  'DM','8','DM','Dominica' from dual union
        select  'DO','9','DO','Dominican Rep.' from dual union
        select  'SV','10','SV','El Salvador' from dual union
        select  'GD','11','GD','Grenada' from dual union
        select  'GT','12','GT','Guatemala' from dual union
        select  'HT','13','HT','Haiti' from dual union
        select  'HN','14','HN','Honduras' from dual union
        select  'JM','15','JM','Jamaica' from dual union
        select  'MX','16','MX','Mexico' from dual union
        select  'NI','17','NI','Nicaragua' from dual union
        select  'PA','18','PA','Panama' from dual union
        select  'KN','19','KN','St. Kitts \& Nevis' from dual union
        select  'LC','20','LC','St. Lucia' from dual union
        select  'VC','21','VC','St. Vincent \& the Grenadines' from dual union
        select  'TT','22','TT','Trinidad \& Tobago' from dual union
        select  'US','23','US','United States' from dual union
        select  'GL','24','GL','Greenland' from dual union
        select  'AR','25','AR','Argentina' from dual union
        select  'BO','26','BO','Bolivia' from dual union
        select  'BR','27','BR','Brazil' from dual union
        select  'CL','28','CL','Chile' from dual union
        select  'CO','29','CO','Colombia' from dual union
        select  'EC','30','EC','Ecuador' from dual union
        select  'FK','31','FK','Falkland Islands' from dual union
        select  'GF','32','GF','French Guiana' from dual union
        select  'GY','33','GY','Guyana' from dual union
        select  'PY','34','PY','Paraguay' from dual union
        select  'PE','35','PE','Peru' from dual union
        select  'SR','36','SR','Suriname' from dual union
        select  'UY','37','UY','Uruguay' from dual union
        select  'VE','38','VE','Venezuela' from dual union
        select  'DZ','39','DZ','Algeria' from dual union
        select  'AO','40','AO','Angola' from dual union
        select  'BJ','41','BJ','Benin' from dual union
        select  'BW','42','BW','Botswana' from dual union
        select  'BF','43','BF','Burkina Faso' from dual union
        select  'BI','44','BI','Burundi' from dual union
        select  'CM','45','CM','Cameroon' from dual union
        select  'CV','46','CV','Cape Verde' from dual union
        select  'CP','47','CP','Central African Republic' from dual union
        select  'TD','48','TD','Chad' from dual union
        select  'KM','49','KM','Comoros' from dual union
        select  'CI','50','CI','Cote d Ivoire' from dual union
        select  'CD','51','CD','Democratic Republic of the Congo' from dual union
        select  'DJ','52','DJ','Djibouti' from dual union
        select  'EG','53','EG','Egypt' from dual union
        select  'GQ','54','GQ','Equatorial Guinea' from dual union
        select  'ER','55','ER','Eritrea' from dual union
        select  'ET','56','ET','Ethiopia' from dual union
        select  'GA','57','GA','Gabon' from dual union
        select  'GH','58','GH','Ghana' from dual union
        select  'GN','59','GN','Guinea' from dual union
        select  'GW','60','GW','Guinea-Bissau' from dual union
        select  'KE','61','KE','Kenya' from dual union
        select  'LS','62','LS','Lesotho' from dual union
        select  'LI','63','LI','Liberia' from dual union
        select  'LR','64','LR','Libya' from dual union
        select  'MS','65','MS','Madagascar' from dual union
        select  'MW','66','MW','Malawi' from dual union
        select  'ML','67','ML','Mali' from dual union
        select  'MR','68','MR','Mauritania' from dual union
        select  'MA','69','MA','Morocco' from dual union
        select  'MZ','70','MZ','Mozambique' from dual union
        select  'NA','71','NA','Namibia' from dual union
        select  'NE','72','NE','Niger' from dual union
        select  'NG','73','NG','Nigeria' from dual union
        select  'RW','74','RW','Rwanda' from dual union
        select  'ST','75','ST','Sao Tome and Principe' from dual union
        select  'SN','76','SN','Senegal' from dual union
        select  'SC','77','SC','Seychelles' from dual union
        select  'SL','78','SL','Sierra Leone' from dual union
        select  'SO','79','SO','Somalia' from dual union
        select  'ZA','80','ZA','South Africa' from dual union
        select  'SD','81','SD','Sudan' from dual union
        select  'SZ','82','SZ','Swaziland' from dual union
        select  'TZ','83','TZ','Tanzania' from dual union
        select  'TG','84','TG','Togo' from dual union
        select  'TN','85','TN','Tunisia' from dual union
        select  'UG','86','UG','Uganda' from dual union
        select  'WA','87','WA','Western Sahara' from dual union
        select  'ZM','88','ZM','Zambia' from dual union
        select  'ZW','89','ZW','Zimbabwe' from dual union
        select  'GM','90','GM','Gambia' from dual union
        select  'CG','91','CG','Congo' from dual union
        select  'MI','92','MI','Mauritius' from dual union
        select  'AF','93','AF','Afghanistan' from dual union
        select  'AM','94','AM','Armenia' from dual union
        select  'AZ','95','AZ','Azerbaijan' from dual union
        select  'BD','96','BD','Bangladesh' from dual union
        select  'BT','97','BT','Bhutan' from dual union
        select  'BN','98','BN','Brunei' from dual union
        select  'MM','99','MM','Burma (Myanmar)' from dual union
        select  'KH','100','KH','Cambodia' from dual union
        select  'CN','101','CN','China' from dual union
        select  'TP','102','TP','East Timor' from dual union
        select  'GE','103','GE','Georgia' from dual union
        select  'IN','104','IN','India' from dual union
        select  'ID','105','ID','Indonesia' from dual union
        select  'IA','106','IA','Iran' from dual union
        select  'JP','107','JP','Japan' from dual union
        select  'KZ','108','KZ','Kazakhstan' from dual union
        select  'KP','109','KP','Korea (north)' from dual union
        select  'KR','110','KR','Korea (south)' from dual union
        select  'KG','111','KG','Kyrgyzstan' from dual union
        select  'LA','112','LA','Laos' from dual union
        select  'MY','113','MY','Malaysia' from dual union
        select  'MN','114','MN','Mongolia' from dual union
        select  'NP','115','NP','Nepal' from dual union
        select  'PK','116','PK','Pakistan' from dual union
        select  'PH','117','PH','Philippines' from dual union
        select  'RU','118','RU','Russia' from dual union
        select  'SG','119','SG','Singapore' from dual union
        select  'LK','120','LK','Sri Lanka' from dual union
        select  'TJ','121','TJ','Tajikistan' from dual union
        select  'TH','122','TH','Thailand' from dual union
        select  'TM','123','TM','Turkmenistan' from dual union
        select  'UZ','124','UZ','Uzbekistan' from dual union
        select  'VN','125','VN','Vietnam' from dual union
        select  'TW','126','TW','Taiwan' from dual union
        select  'HK','127','HK','Hong Kong' from dual union
        select  'MO','128','MO','Macau' from dual union
        select  'AL','129','AL','Albania' from dual union
        select  'AD','130','AD','Andorra' from dual union
        select  'AT','131','AT','Austria' from dual union
        select  'BY','132','BY','Belarus' from dual union
        select  'BE','133','BE','Belgium' from dual union
        select  'BH','134','BH','Bosnia and Herzegovina' from dual union
        select  'BG','135','BG','Bulgaria' from dual union
        select  'HY','136','HY','Croatia' from dual union
        select  'CZ','137','CZ','Czech Republic' from dual union
        select  'DK','138','DK','Denmark' from dual union
        select  'EE','139','EE','Estonia' from dual union
        select  'FI','140','FI','Finland' from dual union
        select  'FR','141','FR','France' from dual union
        select  'DE','142','DE','Germany' from dual union
        select  'GR','143','GR','Greece' from dual union
        select  'HU','144','HU','Hungary' from dual union
        select  'IS','145','IS','Iceland' from dual union
        select  'IR','146','IR','Ireland' from dual union
        select  'IT','147','IT','Italy' from dual union
        select  'LV','148','LV','Latvia' from dual union
        select  'LN','149','LN','Liechtenstein' from dual union
        select  'LT','150','LT','Lithuania' from dual union
        select  'LU','151','LU','Luxembourg' from dual union
        select  'MK','152','MK','Macedonia' from dual union
        select  'MT','153','MT','Malta' from dual union
        select  'MV','154','MV','Moldova' from dual union
        select  'MC','155','MC','Monaco' from dual union
        select  'MG','156','MG','Montenegro' from dual union
        select  'NL','157','NL','Netherlands' from dual union
        select  'NO','158','NO','Norway' from dual union
        select  'PL','159','PL','Poland' from dual union
        select  'PT','160','PT','Portugal' from dual union
        select  'RO','161','RO','Romania' from dual union
        select  'SM','162','SM','San Marino' from dual union
        select  'CS','163','CS','Serbia' from dual union
        select  'SK','164','SK','Slovakia' from dual union
        select  'SI','165','SI','Slovenia' from dual union
        select  'ES','166','ES','Spain' from dual union
        select  'SE','167','SE','Sweden' from dual union
        select  'CH','168','CH','Switzerland' from dual union
        select  'UA','169','UA','Ukraine' from dual union
        select  'UK','170','UK','United Kingdom' from dual union
        select  'VA','171','VA','Vatican City' from dual union
        select  'CY','172','CY','Cyprus' from dual union
        select  'TK','173','TK','Turkey' from dual union
        select  'AU','175','AU','Australia' from dual union
        select  'FJ','176','FJ','Fiji' from dual union
        select  'KI','177','KI','Kiribati' from dual union
        select  'MH','178','MH','Marshall Islands' from dual union
        select  'FM','179','FM','Micronesia' from dual union
        select  'NR','180','NR','Nauru' from dual union
        select  'NZ','181','NZ','New Zealand' from dual union
        select  'PW','182','PW','Palau' from dual union
        select  'PG','183','PG','Papua New Guinea' from dual union
        select  'WS','184','WS','Samoa' from dual union
        select  'SB','185','SB','Solomon Islands' from dual union
        select  'TO','186','TO','Tonga' from dual union
        select  'TV','187','TV','Tuvalu' from dual union
        select  'VU','188','VU','Vanuatu' from dual union
        select  'NC','189','NC','New Caledonia' from dual union
        select  'BA','190','BA','Bahrain' from dual union
        select  'IZ','191','IZ','Iraq' from dual union
        select  'IE','192','IE','Israel' from dual union
        select  'JO','193','JO','Jordan' from dual union
        select  'KU','194','KU','Kuwait' from dual union
        select  'LB','195','LB','Lebanon' from dual union
        select  'OM','196','OM','Oman' from dual union
        select  'QA','197','QA','Qatar' from dual union
        select  'SA','198','SA','Saudi Arabia' from dual union
        select  'SY','199','SY','Syria' from dual union
        select  'AE','200','AE','UnitedArabEmirates' from dual union
        select  'YM','201','YM','Yemen' from dual union
        select  'PR','202','PR','Puerto Rico' from dual union
        select  'KY','203','KY','Cayman Islands' from dual union
        select  'SS','204','SS','South Sudan' from dual union
        select  'KO','205','KO','Kosovo' from dual;

COMMIT;
		
create table jrs_fusionmap_usa(
id  number(20) 	NOT NULL ,
geoname_state varchar2(2),
chartentityid varchar2(2),
shortname varchar2(2) ,
longname varchar2(20), 
col1 		varchar2(255),
col2 		varchar2(255),
col3 		varchar2(255),
col4 		varchar2(255),
col5 		varchar2(255),
constraint pk_jrs_fusionmap_usa primary key(id)
	) 
;

CREATE SEQUENCE SEQ_jrs_fusionmap_usa
  START WITH 1
  MAXVALUE 999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20;

-- DELIMITER /
  
CREATE OR REPLACE TRIGGER TRG_jrs_fusionmap_usa BEFORE INSERT ON jrs_fusionmap_usa
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      SELECT SEQ_jrs_fusionmap_usa.nextval into :new.id from dual; 
   END IF;
END;
/ 

insert into jrs_fusionmap_usa(geoname_state,chartentityid,shortname,longname)
    select  'AL','AL','AL','Alabama' from dual union
    select  'AK','AK','AK','Alaska' from dual union
    select  'AZ','AZ','AZ','Arizona' from dual union
    select  'AR','AR','AR','Arkansas' from dual union
    select  'CA','CA','CA','California' from dual union
    select  'CO','CO','CO','Colorado' from dual union
    select  'CT','CT','CT','Connecticut' from dual union
    select  'DC','DC','DC','District of Columbia' from dual union
    select  'DE','DE','DE','Delaware' from dual union
    select  'FL','FL','FL','Florida' from dual union
    select  'GA','GA','GA','Georgia' from dual union
    select  'HI','HI','HI','Hawaii' from dual union
    select  'ID','ID','ID','Idaho' from dual union
    select  'IL','IL','IL','Illinois' from dual union
    select  'IN','IN','IN','Indiana' from dual union
    select  'IA','IA','IA','Iowa' from dual union
    select  'KS','KS','KS','Kansas' from dual union
    select  'KY','KY','KY','Kentucky' from dual union
    select  'LA','LA','LA','Louisiana' from dual union
    select  'ME','ME','ME','Maine' from dual union
    select  'MD','MD','MD','Maryland' from dual union
    select  'MA','MA','MA','Massachusetts' from dual union
    select  'MI','MI','MI','Michigan' from dual union
    select  'MN','MN','MN','Minnesota' from dual union
    select  'MS','MS','MS','Mississippi' from dual union
    select  'MO','MO','MO','Missouri' from dual union
    select  'MT','MT','MT','Montana' from dual union
    select  'NE','NE','NE','Nebraska' from dual union
    select  'NV','NV','NV','Nevada' from dual union
    select  'NH','NH','NH','New Hampshire' from dual union
    select  'NJ','NJ','NJ','New Jersey' from dual union
    select  'NM','NM','NM','New Mexico' from dual union
    select  'NY','NY','NY','New York' from dual union
    select  'NC','NC','NC','North Carolina' from dual union
    select  'ND','ND','ND','North Dakota' from dual union
    select  'OH','OH','OH','Ohio' from dual union
    select  'OK','OK','OK','Oklahoma' from dual union
    select  'OR','OR','OR','Oregon' from dual union
    select  'PA','PA','PA','Pennsylvania' from dual union
    select  'RI','RI','RI','Rhode Island' from dual union
    select  'SC','SC','SC','South Carolina' from dual union
    select  'SD','SD','SD','South Dakota' from dual union
    select  'TN','TN','TN','Tennessee' from dual union
    select  'TX','TX','TX','Texas' from dual union
    select  'UT','UT','UT','Utah' from dual union
    select  'VT','VT','VT','Vermont' from dual union
    select  'VA','VA','VA','Virginia' from dual union
    select  'WA','WA','WA','Washington' from dual union
    select  'WV','WV','WV','West Virginia' from dual union
    select  'WI','WI','WI','Wisconsin' from dual union
    select  'WY','WY','WY','Wyoming' from dual;

	COMMIT;

create table dim_date
(
id  number(20) 	NOT NULL ,
  date_key number(10) not null,
  dt date not null,
  year_number number(10) not null,
  quarter_number number(10) not null,
  quarter_name varchar2(10) not null,
  month_number number(10) not null,
  month_name varchar2(10) not null,
  month_short_name varchar2(3) not null, 
  week_of_year number(10) not null,
  week_of_month number(10) not null,
  month_full_weeks number(10) not null,
  full_week_flag number(10) not null,
  day_of_week_number number(10) not null,
  day_of_week_short_name varchar2(3) not null,
  day_of_week_name varchar2(10) not null,
  day_number number(10) not null,
constraint pk_dim_date primary key(id)
	) 
;

create table tmp_calendar (dt timestamp)
;

create view vw_dim_date 
as
select 
  date_key,
  dt,
  year_number,
  quarter_number,
  quarter_name,
  month_number,
  month_name,
  month_short_name,
  week_of_year,
  week_of_month,
  month_full_weeks,
  full_week_flag,
  day_of_week_number,
  day_of_week_short_name,
  day_of_week_name,
  day_number
from dim_date;

commit;

CREATE OR REPLACE VIEW vw_middleware_requests
AS 
SELECT m.kaid, m.eid AS environmentid, m.awsid, m.ebid, m.did AS deviceid, m.aid AS appid, m.aname AS appname, m.rid AS requestid, m.sid AS sessionid,
        CASE
            WHEN m.chnl = 'mobile' THEN 'Mobile'
            WHEN m.chnl = 'tablet' THEN 'Tablet'
            WHEN m.chnl = 'desktop' THEN 'Desktop'
            ELSE ' '
        END AS channel,
        CASE
            WHEN m.atype = 'hybrid' THEN 'Hybrid'
            WHEN m.atype = 'native' THEN 'Native'
            WHEN m.atype = 'mixedmode' THEN 'Mixed-Mode'
            WHEN m.atype = 'spa' THEN 'SPA'
            WHEN m.atype = 'mobileweb' THEN 'Mobile Web'
            ELSE ' '
        END AS apptype,
        CASE
            WHEN m.plat = 'ios' THEN 'iOS'
            WHEN m.plat = 'android' THEN 'Android'
            WHEN m.plat = 'blackberry' THEN 'Blackberry'
            WHEN m.plat = 'windows' THEN 'Windows'
            WHEN m.plat = 'j2me' THEN 'j2me'
            ELSE ' '
        END AS platform, m.idur, m.tdur, m.predur, m.exdur, m.prsdur, m.postdur, m.rip AS remoteip, m.ts as ts, m.dm AS devicemodel, m.os AS osversion, m.ua AS useragent, m.svcid AS serviceid, m.fid AS formid,
        CASE
            WHEN m.stype = 'b2c' THEN 'B2C'
            WHEN m.stype = 'b2e' THEN 'B2E'
            ELSE ' '
        END AS sessiontype, m.session_key, m.request_key, m.kuid, m.country, m.region as region, m.city, m.zip, m.lat, m.lon, m.dmacd, m.areacd, 1 AS cnt,
        CASE
            WHEN m.chnl = 'desktop' THEN 'D'
            WHEN m.atype = 'hybrid' OR m.atype = 'spa' OR m.atype = 'mobileweb' THEN 'W'
            ELSE 'N'
        END AS usagetype,
		sdktype,
		sdkversion,
		opstatus,
		httpcode,
		errmsg,
		errstack_var,
		errstack
   FROM middleware_requests m;



CREATE OR REPLACE VIEW vw_middleware_sessions
AS 
SELECT m.kaid, m.eid AS environmentid, m.awsid, m.ebid, m.did AS deviceid, m.aid AS appid, m.aname AS appname, m.sid AS sessionid,
        CASE
            WHEN m.chnl = 'mobile' THEN 'Mobile'
            WHEN m.chnl = 'tablet' THEN 'Tablet'
            WHEN m.chnl = 'desktop' THEN 'Desktop'
            ELSE ' '
        END AS channel,
        CASE
            WHEN m.atype = 'hybrid' THEN 'Hybrid'
            WHEN m.atype = 'native' THEN 'Native'
            WHEN m.atype = 'mixedmode' THEN 'Mixed-Mode'
            WHEN m.atype = 'spa' THEN 'SPA'
            WHEN m.atype = 'mobileweb' THEN 'Mobile Web'
            ELSE ' '
        END AS apptype,
        CASE
            WHEN m.plat = 'ios' THEN 'iOS'
            WHEN m.plat = 'android' THEN 'Android'
            WHEN m.plat = 'blackberry' THEN 'Blackberry'
            WHEN m.plat = 'windows' THEN 'Windows'
            WHEN m.plat = 'j2me' THEN 'j2me'
            ELSE ' '
        END AS platform, m.tdur, m.rip AS remoteip, m.ts, m.dm AS devicemodel, m.os AS osversion, m.ua AS useragent,
        CASE
            WHEN m.stype = 'b2c' THEN 'B2C'
            WHEN m.stype = 'b2e' THEN 'B2E'
            ELSE ' '
        END AS sessiontype, m.session_key, m.kuid, m.country, m.region, m.city, m.zip, m.lat, m.lon, m.dmacd, m.areacd, 1 AS cnt,
        CASE
            WHEN m.chnl = 'desktop' THEN 'D'
            WHEN m.atype = 'hybrid' OR m.atype = 'spa' OR m.atype = 'mobileweb' THEN 'W'
            ELSE 'N'
        END AS usagetype,
		sdktype,
		sdkversion,
		opstatus,
		httpcode,
		errmsg,
		errstack_var,
		errstack
   FROM middleware_sessions m;


--add additional columns to application_events
alter table application_events drop column col1;
alter table application_events drop column col2;
alter table application_events drop column col3;
alter table application_events drop column col4;
alter table application_events drop column col5;


ALTER TABLE application_events ADD awsid varchar2(255) ;
ALTER TABLE application_events ADD ebid	varchar2(255) ;
ALTER TABLE application_events ADD rid	varchar2(255) ;
ALTER TABLE application_events ADD did	varchar2(255) ;
ALTER TABLE application_events ADD aname	varchar2(255)    NOT NULL ;
ALTER TABLE application_events ADD atype	varchar2(255)    NOT NULL ;
ALTER TABLE application_events ADD chnl	varchar2(255)    NOT NULL ;
ALTER TABLE application_events ADD plat	varchar2(255)    NOT NULL ;
ALTER TABLE application_events ADD rip	varchar2(255) ;
ALTER TABLE application_events ADD dm    varchar2(255) ;
ALTER TABLE application_events ADD os	varchar2(255) ;
ALTER TABLE application_events ADD ua	varchar2(255) ;
ALTER TABLE application_events ADD stype	varchar2(255)     NOT NULL;   	
ALTER TABLE application_events ADD aver	varchar2(255);   		
ALTER TABLE application_events ADD kuid		varchar2(255);   		
ALTER TABLE application_events ADD country	varchar2(2);   		
ALTER TABLE application_events ADD region	varchar2(2);   		
ALTER TABLE application_events ADD city		varchar2(255);   		
ALTER TABLE application_events ADD zip		varchar2(6);   		
ALTER TABLE application_events ADD lat		number(8,5);   		
ALTER TABLE application_events ADD lon		number(8,5);   		
ALTER TABLE application_events ADD dmacd     integer;   		
ALTER TABLE application_events ADD areacd	varchar2(3);   		
ALTER TABLE application_events ADD sdktype varchar2(50);
ALTER TABLE application_events ADD sdkversion varchar2(50) ;
	
ALTER TABLE application_events ADD col1	varchar(255) ;
ALTER TABLE application_events ADD col2	varchar(255) ;
ALTER TABLE application_events ADD col3	varchar(255) ;
ALTER TABLE application_events ADD col4	varchar(255) ;
ALTER TABLE application_events ADD col5	varchar(255) ;


ALTER TABLE application_service_Detail modify aname	varchar2(255)    NOT NULL ;
ALTER TABLE application_error_Detail modify aname	varchar2(255)    NOT NULL ;

alter table application_service_detail  drop column col1;
alter table application_service_detail  drop column col2;
alter table application_service_detail  drop column col3;
alter table application_service_detail  drop column col4;
alter table application_service_detail  drop column col5;


ALTER TABLE application_service_Detail ADD did	varchar2(255) ;
ALTER TABLE application_service_Detail ADD dm    varchar2(255) ;
ALTER TABLE application_service_Detail ADD os	varchar2(255) ;
ALTER TABLE application_service_Detail ADD ua	varchar2(255) ;
ALTER TABLE application_service_Detail ADD aver	varchar2(255);   		
ALTER TABLE application_service_Detail ADD kuid		varchar2(255);   		
ALTER TABLE application_service_Detail ADD sdktype varchar2(50);
ALTER TABLE application_service_Detail ADD sdkversion varchar2(50) ;

ALTER TABLE application_service_detail ADD col1	varchar(255) ;
ALTER TABLE application_service_detail ADD col2	varchar(255) ;
ALTER TABLE application_service_detail ADD col3	varchar(255) ;
ALTER TABLE application_service_detail ADD col4	varchar(255) ;
ALTER TABLE application_service_detail ADD col5	varchar(255) ;

alter table application_error_detail drop column col1;
alter table application_error_detail drop column col2;
alter table application_error_detail drop column col3;
alter table application_error_detail drop column col4;
alter table application_error_detail drop column col5;

ALTER TABLE application_error_Detail ADD sessionid	varchar2(255) ;
ALTER TABLE application_error_Detail ADD did	varchar2(255) ;
ALTER TABLE application_error_Detail ADD dm    varchar2(255) ;
ALTER TABLE application_error_Detail ADD os	varchar2(255) ;
ALTER TABLE application_error_Detail ADD ua	varchar2(255) ;
ALTER TABLE application_error_Detail ADD aver	varchar2(255);   		
ALTER TABLE application_error_Detail ADD kuid		varchar2(255);   		
ALTER TABLE application_error_Detail ADD sdktype varchar2(50);
ALTER TABLE application_error_Detail ADD sdkversion varchar2(50) ;
ALTER TABLE application_error_Detail ADD pluginverplat varchar2(255) ;
ALTER TABLE application_error_Detail ADD pluginveride varchar2(2048) ;

ALTER TABLE application_error_detail ADD col1	varchar(255) ;
ALTER TABLE application_error_detail ADD col2	varchar(255) ;
ALTER TABLE application_error_detail ADD col3	varchar(255) ;
ALTER TABLE application_error_detail ADD col4	varchar(255) ;
ALTER TABLE application_error_detail ADD col5	varchar(255) ;


CREATE VIEW vw_application_events
(
  kaid,
  environmentid,
  awsid,
  ebid,
  deviceid,
  appid,
  appname,
  sessionid,
  channel,
  apptype,
  platform,
  remoteip,
  ts,
  devicemodel,
  osversion,
  useragent,
  sessiontype,
  session_key,
  request_key,
  kuid,
  country,
  region,
  city,
  zip,
  lat,
  lon,
  dmacd,
  areacd,
  cnt,
  usagetype,
  sdktype,
  skdversion,
  evttype,
  formid,
  widgetid,
  evtsubtype,
  flowtag,
  metadata
)
AS
 SELECT ae.kaid, ae.eid AS environmentid, ae.awsid, ae.ebid, ae.did AS deviceid, ae.aid AS appid, ae.aname AS appname, ae.sid AS sessionid,
   CASE
            WHEN ae.chnl = 'mobile' THEN 'Mobile'
            WHEN ae.chnl = 'tablet' THEN 'Tablet'
            WHEN ae.chnl = 'desktop' THEN 'Desktop'
            ELSE ' '
        END AS channel,
        CASE
            WHEN ae.atype = 'hybrid' THEN 'Hybrid'
            WHEN ae.atype = 'native' THEN 'Native'
            WHEN ae.atype = 'mixedmode' THEN 'Mixed-Mode'
            WHEN ae.atype = 'spa' THEN 'SPA'
            WHEN ae.atype = 'mobileweb' THEN 'Mobile Web'
            ELSE ' '
        END AS apptype,
        CASE
            WHEN ae.plat = 'ios' THEN 'iOS'
            WHEN ae.plat = 'android' THEN 'Android'
            WHEN ae.plat = 'blackberry' THEN 'Blackberry'
            WHEN ae.plat = 'windows' THEN 'Windows'
            WHEN ae.plat = 'j2me' THEN 'j2me'
            ELSE ' '
        END AS platform, ae.rip AS remoteip, ae.ts, ae.dm AS devicemodel, ae.os AS osversion, ae.ua AS useragent,
        CASE
            WHEN ae.stype = 'b2c' THEN 'B2C'
            WHEN ae.stype = 'b2e' THEN 'B2E'
            ELSE ' '
        END AS sessiontype, ae.session_key, ae.request_key, ae.kuid, ae.country, ae.region, ae.city, ae.zip, ae.lat, ae.lon, ae.dmacd, ae.areacd, 1 AS cnt,
        CASE
            WHEN ae.chnl = 'desktop' THEN 'D'
            WHEN ae.atype = 'hybrid' OR ae.atype = 'spa' OR ae.atype = 'mobileweb' THEN 'W'
            ELSE 'N'
        END AS usagetype, ae.sdktype, ae.sdkversion AS skdversion, ae.evttype, ae.formid, ae.widgetid, ae.evtsubtype, ae.flowtag, ae.metadata
   FROM application_events ae;



CREATE VIEW "vw_middleware_requests"
AS 
SELECT m.kaid as "kaid", m.eid AS "environmentid", m.awsid as "awsid", m.ebid as "ebid", m.did AS "deviceid", m.aid AS "appid", m.aname AS "appname", 
m.rid AS "requestid", m.sid AS "sessionid",
        CASE
            WHEN m.chnl = 'mobile' THEN 'Mobile'
            WHEN m.chnl = 'tablet' THEN 'Tablet'
            WHEN m.chnl = 'desktop' THEN 'Desktop'
            ELSE ' '
        END AS "channel",
        CASE
            WHEN m.atype = 'hybrid' THEN 'Hybrid'
            WHEN m.atype = 'native' THEN 'Native'
            WHEN m.atype = 'mixedmode' THEN 'Mixed-Mode'
            WHEN m.atype = 'spa' THEN 'SPA'
            WHEN m.atype = 'mobileweb' THEN 'Mobile Web'
            ELSE ' '
        END AS "apptype",
        CASE
            WHEN m.plat = 'ios' THEN 'iOS'
            WHEN m.plat = 'android' THEN 'Android'
            WHEN m.plat = 'blackberry' THEN 'Blackberry'
            WHEN m.plat = 'windows' THEN 'Windows'
            WHEN m.plat = 'j2me' THEN 'j2me'
            ELSE ' '
        END AS "platform", m.idur as "idur", m.tdur as "tdur", m.predur as "predur", m.exdur as "exdur", m.prsdur as "prsdur", 
		m.postdur as "postdur", m.rip AS "remoteip", m.ts as "ts", m.dm AS "devicemodel", m.os AS "osversion", m.ua AS "useragent", 
		m.svcid AS "serviceid", m.fid AS "formid",
        CASE
            WHEN m.stype = 'b2c' THEN 'B2C'
            WHEN m.stype = 'b2e' THEN 'B2E'
            ELSE ' '
        END AS "sessiontype", m.session_key as "session_key", m.request_key as "request_key", m.kuid as "kuid", m.country as "country", 
		m.region as "region", m.city as "city", m.zip as "zip", m.lat as "lat", m.lon as "lon", m.dmacd as "dmacd", m.areacd as "areacd", 1 AS "cnt",
        CASE
            WHEN m.chnl = 'desktop' THEN 'D'
            WHEN m.atype = 'hybrid' OR m.atype = 'spa' OR m.atype = 'mobileweb' THEN 'W'
            ELSE 'N'
        END AS "usagetype",
		sdktype as "sdktype",
		sdkversion as "sdkversion",
		opstatus as "opstatus",
		httpcode as "httpcode",
		errmsg as "errmsg",
		errstack_var as "errstack_var",
		errstack as "errstack"
   FROM middleware_requests m;

   
   
drop trigger TRG_middleware_sessions ;
drop trigger TRG_middleware_requests;
drop trigger TRG_custom_metrics_master;
drop trigger TRG_service_mapping;
drop trigger TRG_form_mapping;
drop trigger TRG_invalid_messages;
drop trigger TRG_reports_settings;
drop trigger TRG_dw_keys_request;
drop trigger TRG_dw_keys_session;
drop trigger TRG_crpt_metric;
drop trigger TRG_crpt_owner;
drop trigger TRG_crpt_master_info;
drop trigger TRG_jrs_fusionmap_usa;
drop trigger TRG_jrs_fusionmap_world;

-- DELIMITER /
CREATE OR REPLACE TRIGGER TRG_service_mapping BEFORE INSERT ON service_mapping
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      SELECT SEQ_service_mapping.nextval into :new.id from dual; 
   END IF;
END;
/

-- DELIMITER /
CREATE OR REPLACE TRIGGER TRG_form_mapping BEFORE INSERT ON form_mapping
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      SELECT SEQ_form_mapping.nextval into :new.id from dual; 
   END IF;
END;
/

-- DELIMITER /
CREATE OR REPLACE TRIGGER TRG_reports_settings BEFORE INSERT ON reports_settings
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      SELECT SEQ_reports_settings.nextval into :new.id from dual; 
   END IF;
END;
/

DECLARE max_id number; cur_seq number; BEGIN SELECT NVL(max(id),0) into max_id from form_mapping; 
select 1 into cur_seq from dual; while cur_seq < max_id LOOP SELECT SEQ_form_mapping.nextval INTO cur_seq FROM dual; END LOOP; END;
/

DECLARE max_id number; cur_seq number; BEGIN SELECT NVL(max(id),0) into max_id from service_mapping; 
select 1 into cur_seq from dual; while cur_seq < max_id LOOP SELECT SEQ_service_mapping.nextval INTO cur_seq FROM dual; END LOOP; END;
/

DECLARE max_id number; cur_seq number; BEGIN SELECT NVL(max(id),0) into max_id from reports_settings; 
select 1 into cur_seq from dual; while cur_seq < max_id LOOP SELECT SEQ_reports_settings.nextval INTO cur_seq FROM dual; END LOOP; END;
/

DECLARE max_id number; cur_seq number; BEGIN SELECT NVL(max(id),0) into max_id from crpt_master_info; 
select 1 into cur_seq from dual; while cur_seq < max_id LOOP SELECT SEQ_crpt_master_info.nextval INTO cur_seq FROM dual; END LOOP; END;
/
