-- login to konyadmin schema
-- DELIMITER /

DECLARE max_id number; cur_seq number; BEGIN SELECT NVL(max(id),0) into max_id from roles; select '1' into cur_seq from dual; while cur_seq < max_id LOOP SELECT SEQ_roles.nextval INTO cur_seq FROM dual; END LOOP; END;
/

DECLARE max_id number; cur_seq number; BEGIN SELECT NVL(max(id),0) into max_id from users; select '1' into cur_seq from dual; while cur_seq < max_id LOOP SELECT SEQ_users.nextval INTO cur_seq FROM dual; END LOOP; END;
/

-- DELIMITER / 

CREATE OR REPLACE TRIGGER TRG_users BEFORE INSERT ON users
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      select SEQ_users.nextval into :new.id from dual;
   END IF;

END;
/

-- DELIMITER /
  
CREATE OR REPLACE TRIGGER TRG_roles BEFORE INSERT ON roles
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      select SEQ_roles.nextval into :new.id from dual; 
   END IF;

END;
/

-- DELIMITER /

CREATE OR REPLACE TRIGGER TRG_mobilefabric_configuration BEFORE INSERT ON mobilefabric_configuration
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN
      select SEQ_mobilefabric_configuration.nextval into :new.id from dual;
   END IF;

END;
/

-- DELIMITER /  

CREATE OR REPLACE TRIGGER TRG_mobilefabric_environment BEFORE INSERT ON mobilefabric_environment
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.id IS NULL THEN 
      select SEQ_mobilefabric_environment.nextval into :new.id from dual;
   END IF;

END;
/

-- DELIMITER /
  
CREATE OR REPLACE TRIGGER TRG_app_war_info BEFORE INSERT ON app_war_info
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.app_war_id IS NULL THEN
      select SEQ_app_war_info.nextval into :new.app_war_id from dual;
   END IF;

END;
/

-- DELIMITER /
  
CREATE OR REPLACE TRIGGER TRG_app_info BEFORE INSERT ON app_info
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.app_id IS NULL THEN    
      select SEQ_app_info.nextval into :new.app_id from dual;
   END IF;

END;
/

-- DELIMITER /
  
CREATE OR REPLACE TRIGGER TRG_jar_info BEFORE INSERT ON jar_info
FOR EACH ROW
BEGIN
  IF INSERTING AND :new.jar_id IS NULL THEN
      select SEQ_jar_info.nextval into :new.jar_id from dual;
   END IF;

END;
/


-- DELIMITER ;
insert  into build_version(build_version,build_date) values ('MIDDLEWARE-GA-6.5.0.0',to_date(sysdate,'yyyy-mm-dd hh24:mi:ss'));
CREATE TABLE "schema_version"
(
   "version_rank"    NUMBER                NOT NULL,
   "installed_rank"  NUMBER                NOT NULL,
   "version"         VARCHAR2(50 Byte)     NOT NULL,
   "description"     VARCHAR2(200 Byte)    NOT NULL,
   "type"            VARCHAR2(20 Byte)     NOT NULL,
   "script"          VARCHAR2(1000 Byte)   NOT NULL,
   "checksum"        NUMBER,
   "installed_by"    VARCHAR2(100 Byte)    NOT NULL,
   "installed_on"    TIMESTAMP(6)          DEFAULT CURRENT_TIMESTAMP NOT NULL,
   "execution_time"  NUMBER                NOT NULL,
   "success"         NUMBER(1)             NOT NULL
)
TABLESPACE USERS;

ALTER TABLE "schema_version"
   ADD CONSTRAINT "schema_version_pk"
   PRIMARY KEY ("version") 
   USING INDEX TABLESPACE USERS;

CREATE INDEX "schema_version_ir_idx"
   ON "schema_version" ("installed_rank" ASC)
   TABLESPACE USERS;

CREATE INDEX "schema_version_s_idx"
   ON "schema_version" ("success" ASC)
   TABLESPACE USERS;

CREATE INDEX "schema_version_vr_idx"
   ON "schema_version" ("version_rank" ASC)
   TABLESPACE USERS;


INSERT INTO "schema_version"
(
  "version_rank",
  "installed_rank",
  "version",
  "description",
  "type",
  "script",
  "checksum",
  "installed_by",
  "installed_on",
  "execution_time",
  "success"
)
VALUES
(
  1,
  1,
  '1',
  'konyadmin-oracle-master',
  'SQL',
  'V1__konyadmin-oracle-master.sql',
  228536617,
  'konyadmin',
  TO_TIMESTAMP('2015-06-23 14:04:23.705','YYYY-MM-DD HH24:MI:SS.FF'),
  1384,
  1
);

INSERT INTO "schema_version"
(
  "version_rank",
  "installed_rank",
  "version",
  "description",
  "type",
  "script",
  "checksum",
  "installed_by",
  "installed_on",
  "execution_time",
  "success"
)
VALUES
(
  2,
  2,
  '2',
  'konyadmin-oracle-6.5.0.0',
  'SQL',
  'V2__konyadmin-oracle-6.5.0.0.sql',
  1550521380,
  'konyadmin',
  TO_TIMESTAMP('2015-06-23 14:04:23.736','YYYY-MM-DD HH24:MI:SS.FF'),
  7,
  1
);
commit;