/**Note: Replace database names konyreports and konyadmin with your actual database names.**/
USE [konyreports];

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [reports_settings](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[created_date] [datetime] NULL,
	[created_by] [varchar](255) NULL,
	[updated_date] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[col1] [varchar](255) NULL,
	[col2] [varchar](255) NULL,
	[col3] [varchar](255) NULL,
	[col4] [varchar](255) NULL,
	[col5] [varchar](255) NULL,
	[config_name] [varchar](255) NULL,
	[config_type] [varchar](255) NULL,
	[config_value] [varchar](255) NULL,
	[selected] [tinyint] NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [crpt_owner](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[created_date] [datetime] NULL,
	[created_by] [varchar](255) NULL,
	[updated_date] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[aid] [varchar](255) NULL,
	[col1] [varchar](255) NULL,
	[col2] [varchar](255) NULL,
	[col3] [varchar](255) NULL,
	[col4] [varchar](255) NULL,
	[col5] [varchar](255) NULL,
	[dw_table_name] [varchar](255) NULL,
	[eid] [varchar](255) NULL,
	[jrs_domain] [varchar](255) NULL,
	[kaid] [varchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [crpt_metric](
	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
	[created_date] [datetime] NULL,
	[created_by] [varchar](255) NULL,
	[updated_date] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[aggr_func] [varchar](255) NULL,
	[col1] [varchar](255) NULL,
	[col2] [varchar](255) NULL,
	[col3] [varchar](255) NULL,
	[col4] [varchar](255) NULL,
	[col5] [varchar](255) NULL,
	[dtype] [varchar](255) NULL,
	[dw_column_name] [varchar](255) NULL,
	[is_deleted] [tinyint] NULL,
	[mtype] [varchar](255) NULL,
	[name] [varchar](255) NULL,
	[owner_id] [numeric](19, 0) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dw_keys_request](
	[request_key] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
   	[rid]          	VARCHAR(255)   	NOT NULL,
   	[eid]          	VARCHAR(255)    NOT NULL,
   	[ts]    	DATETIME       NOT NULL,
   	[insert_date]  	DATETIME    NOT NULL DEFAULT CURRENT_TIMESTAMP,
   	[created_date] [DATETIME] NULL,
	[created_by] [varchar](255) NULL,
	[updated_date] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[col1] [varchar](255) NULL,
	[col2] [varchar](255) NULL,
	[col3] [varchar](255) NULL,
	[col4] [varchar](255) NULL,
	[col5] [varchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[request_key] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
UNIQUE NONCLUSTERED 
(
	[rid] ASC,
	[eid] ASC,
	[ts] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dw_keys_session](
	[session_key] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
   	[sid]          VARBINARY(100)  	NOT NULL,
   	[hash_code]    VARBINARY(100)   NOT NULL,
   	[insert_date]  [datetime]  		DEFAULT CURRENT_TIMESTAMP NOT NULL,
   	[created_date] [datetime] NULL,
	[created_by] [varchar](255) NULL,
	[updated_date] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[col1] [varchar](255) NULL,
	[col2] [varchar](255) NULL,
	[col3] [varchar](255) NULL,
	[col4] [varchar](255) NULL,
	[col5] [varchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[session_key] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
UNIQUE NONCLUSTERED 
(
	[sid] ASC,
	[hash_code] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [geolocations_ip4](
   	[startIpNum]  VARCHAR(15),
   	[endIpNum]    VARCHAR(15),
   	[startIpInt]  BIGINT   NOT NULL,
   	[endIpInt]    BIGINT   DEFAULT 0 NOT NULL,
   	[country]     VARCHAR(2),
   	[region]      VARCHAR(2),
   	[city]        VARCHAR(255),
   	[postalCode]  VARCHAR(6),
   	[latitude]    DECIMAL(8,5),
   	[longitude]   DECIMAL(8,5),
   	[dmaCode]     VARCHAR(3),
   	[areaCode]    VARCHAR(3),
   	[IPspatial]   geometry   NOT NULL,
   	[created_date] [datetime] NULL,
	[created_by] [varchar](255) NULL,
	[updated_date] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[col1] [varchar](255) NULL,
	[col2] [varchar](255) NULL,
	[col3] [varchar](255) NULL,
	[col4] [varchar](255) NULL,
	[col5] [varchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[startIpInt] ASC,
	[endIpInt] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [crpt_master_info](
   	[id] [numeric](19, 0) IDENTITY(1,1) NOT NULL,
   	[datatype]      VARCHAR(20)		NOT NULL,
   	[col_prefix]    VARCHAR(20)	    NOT NULL,
   	[col_count]     SMALLINT		NOT NULL,
   	[col_metadata]	VARCHAR(255)	NOT NULL,
   	[jas_datatype]  VARCHAR(255)	NULL,
   	[created_date] [datetime] NULL,
	[created_by] [varchar](255) NULL,
	[updated_date] [datetime] NULL,
	[updated_by] [varchar](255) NULL,
	[col1] [varchar](255) NULL,
	[col2] [varchar](255) NULL,
	[col3] [varchar](255) NULL,
	[col4] [varchar](255) NULL,
	[col5] [varchar](255) NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO

-- Create Index on spatial column
-- CREATE CLUSTERED INDEX ux_geolocations_ip4_spatial ON geolocations_ip4(IPspatial(32)ASC);

/****** Object:  ForeignKey [FKAE5458BCEAAA3BE6]    Script Date: 10/14/2014 00:06:00 ******/
ALTER TABLE [crpt_metric]  WITH CHECK ADD  CONSTRAINT [FKAE5458BCEAAA3BE6] FOREIGN KEY([owner_id])
REFERENCES [crpt_owner] ([id])
GO
ALTER TABLE [crpt_metric] CHECK CONSTRAINT [FKAE5458BCEAAA3BE6]
GO

ALTER TABLE [service_mapping] ALTER COLUMN [menuname] VARCHAR(255) NULL;
ALTER TABLE [service_mapping] ALTER COLUMN [eventname] VARCHAR(255) NULL;
GO

ALTER TABLE [form_mapping] ALTER COLUMN [menuname] VARCHAR(255) NULL;
ALTER TABLE [form_mapping] ALTER COLUMN [eventname] VARCHAR(255) NULL;
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [build_version] (
  	[build_version] [varchar](255) NULL,
	[build_date] [datetime] NULL
)
GO
SET ANSI_PADDING OFF
GO

INSERT INTO [build_version](build_version, build_date) values ('MIDDLEWARE-GA-6.0.3.1', getdate());

/**copy data from konyadmin into konyreports.**/
SET IDENTITY_INSERT [dw_keys_request] ON
INSERT INTO [dw_keys_request] ([request_key],[rid],[eid],[ts],[insert_date],[created_date],[created_by],[updated_date],[updated_by],[col1],[col2],[col3],[col4],[col5]) select [request_key],[rid],[eid],[ts],[insert_date],[created_date],[created_by],[updated_date],[updated_by],[col1],[col2],[col3],[col4],[col5] from [konyadmin].[dbo].[dw_keys_request];
SET IDENTITY_INSERT [dw_keys_request] OFF

SET IDENTITY_INSERT [dw_keys_session] ON
INSERT INTO [dw_keys_session]([session_key],[sid],[hash_code],[insert_date],[created_date],[created_by],[updated_date],[updated_by],[col1],[col2],[col3],[col4],[col5]) select [session_key],[sid],[hash_code],[insert_date],[created_date],[created_by],[updated_date],[updated_by],[col1],[col2],[col3],[col4],[col5] from [konyadmin].[dbo].[dw_keys_session];
SET IDENTITY_INSERT [dw_keys_session] OFF

SET IDENTITY_INSERT [crpt_owner] ON
INSERT INTO [crpt_owner] ([id],[created_date],[created_by],[updated_date],[updated_by],[aid],[col1],[col2],[col3],[col4],[col5],[dw_table_name],[eid],[jrs_domain],[kaid]) select [id],[created_date],[created_by],[updated_date],[updated_by],[aid],[col1],[col2],[col3],[col4],[col5],[dw_table_name],[eid],[jrs_domain],[kaid] from [konyadmin].[dbo].[crpt_owner];
SET IDENTITY_INSERT [crpt_owner] OFF

SET IDENTITY_INSERT [crpt_metric] ON
INSERT INTO [crpt_metric] ([id],[created_date],[created_by],[updated_date],[updated_by],[aggr_func],[col1],[col2],[col3],[col4],[col5],[dtype],[dw_column_name],[is_deleted],[mtype],[name],[owner_id]) select [id],[created_date],[created_by],[updated_date],[updated_by],[aggr_func],[col1],[col2],[col3],[col4],[col5],[dtype],[dw_column_name],[is_deleted],[mtype],[name],[owner_id] from [konyadmin].[dbo].[crpt_metric];
SET IDENTITY_INSERT [crpt_metric] OFF

SET IDENTITY_INSERT [crpt_master_info] ON
INSERT INTO [crpt_master_info]([id],[datatype],[col_prefix],[col_count],[col_metadata],[jas_datatype],[created_date],[created_by],[updated_date],[updated_by],[col1],[col2],[col3],[col4],[col5]) select [id],[datatype],[col_prefix],[col_count],[col_metadata],[jas_datatype],[created_date],[created_by],[updated_date],[updated_by],[col1],[col2],[col3],[col4],[col5] from [konyadmin].[dbo].[crpt_master_info];
SET IDENTITY_INSERT [crpt_master_info] OFF

SET IDENTITY_INSERT [reports_settings] ON
INSERT INTO [reports_settings]([id],[created_date],[created_by],[updated_date],[updated_by],[col1],[col2],[col3],[col4],[col5],[config_name],[config_type],[config_value],[selected]) select [id],[created_date],[created_by],[updated_date],[updated_by],[col1],[col2],[col3],[col4],[col5],[config_name],[config_type],[config_value],[selected] from [konyadmin].[dbo].[reports_settings];
SET IDENTITY_INSERT [reports_settings] OFF

INSERT INTO [geolocations_ip4]([startIpNum],[endIpNum],[startIpInt],[endIpInt],[country],[region],[city],[postalCode],[latitude],[longitude],[dmaCode],[areaCode],[IPspatial],[created_date],[created_by],[updated_date],[updated_by],[col1],[col2],[col3],[col4],[col5]) select [startIpNum],[endIpNum],[startIpInt],[endIpInt],[country],[region],[city],[postalCode],[latitude],[longitude],[dmaCode],[areaCode],[IPspatial],[created_date],[created_by],[updated_date],[updated_by],[col1],[col2],[col3],[col4],[col5] from [konyadmin].[dbo].[geolocations_ip4];
