/** Note: Replace database names konyreports and konyadmin with your actual database names.**/
USE [konyadmin];
INSERT INTO [build_version](build_version, build_date) values ('MIDDLEWARE-GA-6.5.0.0', getdate());
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [schema_version]
(
   [version_rank]    int              NOT NULL,
   [installed_rank]  int              NOT NULL,
   [version]         varchar(50)     NOT NULL,
   [description]     varchar(200),
   [type]            varchar(20)     NOT NULL,
   [script]          varchar(1000)   NOT NULL,
   [checksum]        int,
   [installed_by]    varchar(100)    NOT NULL,
   [installed_on]    datetime         DEFAULT (getdate()) NOT NULL,
   [execution_time]  int              NOT NULL,
   [success]         bit              NOT NULL
);
GO
SET ANSI_PADDING OFF
GO


ALTER TABLE [schema_version]
  ADD CONSTRAINT schema_version_pk
  PRIMARY KEY CLUSTERED (version);
GO
  
CREATE NONCLUSTERED INDEX schema_version_ir_idx
   ON [schema_version] (installed_rank ASC);
GO
CREATE NONCLUSTERED INDEX schema_version_s_idx
   ON [schema_version] (success ASC);
GO
CREATE NONCLUSTERED INDEX schema_version_vr_idx
   ON [schema_version] (version_rank ASC);

GO
INSERT INTO schema_version
(
  version_rank,
  installed_rank,
  version,
  description,
  TYPE,
  script,
  checksum,
  installed_by,
  installed_on,
  execution_time,
  success
)
VALUES
(
  1,
  1,
  N'1',
  N'konyadmin-sqlserver-master',
  N'SQL',
  N'V1__konyadmin-sqlserver-master.sql',
  1170659327,
  N'sa',
  CONVERT(datetime,'2015-06-23 12:53:03.347',120),
  729,
  1
);
GO
INSERT INTO schema_version
(
  version_rank,
  installed_rank,
  version,
  description,
  TYPE,
  script,
  checksum,
  installed_by,
  installed_on,
  execution_time,
  success
)
VALUES
(
  2,
  2,
  N'2',
  N'konyadmin-sqlserver-6.5.0.0',
  N'SQL',
  N'V2__konyadmin-sqlserver-6.5.0.0.sql',
  -1721720594,
  N'sa',
  CONVERT(datetime,'2015-06-23 12:53:03.423',120),
  7,
  1
);
GO